# -*- coding: utf-8 -*-

from sandbox.projects.common.constants import constants as sandbox_constants

from sandbox.projects.release_machine.components import configs as cfg
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.core.releasable_items as ri

import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class DjRthubCfg(cfg.ReferenceBranchedConfig):
    name = "dj_rthub"
    display_name = "DJ RTHub"
    responsible = "alexbudanov"

    class MergesCfg(cfg.ReferenceBranchedConfig.MergesCfg):
        number_last_branches_to_merge = 1

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "YASAP"
        testenv_db_owners = ['alexbudanov', 'volodskikh', 'kcd', 'alekseyzotov', 'dan-chir', 'katsura-a']

        standard_jobs = frozenset([])

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                # build package
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="YA_PACKAGE",
                        out={"DJ_RTHUB_PACKAGE": 180},
                        build_item="RTHUB_PACKAGE",
                        ctx={
                            sandbox_constants.USE_AAPI_FUSE: True,
                            sandbox_constants.ALLOW_AAPI_FALLBACK: True,
                            sandbox_constants.BUILD_TYPE_KEY: "release",
                            sandbox_constants.STRIP_BINARIES: True,
                            "resource_type": "DJ_RTHUB_PACKAGE",
                            "packages": "dj/tools/rthub_profiles/packages/prod_package.json",
                            "compress_package_archive": True,
                            "package_type": "tarball",
                            "use_new_format": True
                        }
                    )
                )
                # release package to prestable
                branch_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.prestable,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="RTHUB_PACKAGE",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "dj_rthub_package",
                                        "DJ_RTHUB_PACKAGE",
                                    ),
                                ),
                            )
                        ),
                    )
                )
                # run acceptance task
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="DJ_RTHUB_ACCEPTANCE",
                        job_params={
                            "test_type": jg_utils.TestType.CHECK_TEST,
                            "job_name_parameter": "ACCEPTANCE",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="RTHUB_PACKAGE",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource("package_resource",  "DJ_RTHUB_PACKAGE")
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            )
                        ),
                        platform="linux",
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_stage = rm_const.ReleaseStatus.stable
                dj_rthub_release_item = "dj_rthub"

                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        release_item=dj_rthub_release_item,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="RTHUB_PACKAGE",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "dj_rthub_package",
                                        "DJ_RTHUB_PACKAGE"
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerNewTag()
                        ),
                    )
                )

                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                    release_item=dj_rthub_release_item
                ))
                return release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["dj-unity-dev@yandex-team.ru"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "alekseyzotov"
            queue = "DJRTHUBRELEASES"
            summary_template = "DJ RTHub Release {}"
            followers = ['alexbudanov', 'kcd', 'alekseyzotov', 'dan-chir', 'katsura-a']
            workflow = rm_const.Workflow.BETA_TEST
            add_commiters_as_followers = False

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/dj/services/rthub",
            "arcadia/dj/tools/rthub_profiles",
            # answers processing
            "arcadia/yweb/yasap/answers_recommender/dj/rthub",
            "arcadia/yweb/yasap/answers_recommender/dj/postgres_profiles_client",
            "arcadia/yweb/yasap/answers_recommender/dj/profiles"
        ]
        wiki_page = "thelenta/djunity/RTHubReleases/"

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="dj_rthub_package",
                    data=ri.SandboxResourceData("DJ_RTHUB_PACKAGE"),
                    deploy_infos=[ri.NannyDeployInfo(
                        [
                            ri.DeployService("rthub-pdb-fresh-profile-prod"),
                            ri.DeployService("rthub-pdb-full-profile-prod"),
                        ]
                    )],
                )
            ]

        allow_robots_to_release_stable = True
