# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.core.releasable_items as ri

import sandbox.projects.release_machine.components.config_core.jg.base as jg_base
import sandbox.projects.release_machine.components.config_core.jg.flow as jg_flow
import sandbox.projects.release_machine.components.config_core.jg.cube.lib.build as jg_cube_build
import sandbox.projects.release_machine.components.config_core.jg.cube.lib.dummy as jg_cube_dummy
import sandbox.projects.release_machine.components.config_core.jg.cube.lib.release as jg_cube_release
import sandbox.projects.release_machine.components.config_core.jg.cube.base as jg_cube_base


class DjUnityCfg(cfg.ReferenceCIConfig):
    name = "dj_unity"
    display_name = "DJ Unity"
    responsible = cfg.Responsible(
        abc=cfg.Abc(service_name="advmachine"),
        login="eugeninic",
    )

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):
        use_arc = True
        start_version = 131  # moved to the CI since 130nd branch

    class MergesCfg(cfg.ReferenceCIConfig.MergesCfg):
        number_last_branches_to_merge = 1

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "dj/unity"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "YASAP"

        ya_make_abs_paths_glob = [
            "dj/unity/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class JG(jg_base.BaseReleaseMachineJobGraph):
        @jg_flow.release_flow()
        def release(self):
            graph = super(DjUnityCfg.JG, self).release(self)

            build_dj_unity_package = jg_cube_build.YaPackage2(
                name="build_dj_unity_package",
                title="Build DJ Unity Package",
                packages=["dj/unity/devops/package.json"],
                resource_types=["DJ_UNITY_PACKAGE"],
                use_compression=True,
                needs=[graph.get(jg_cube_dummy.RMMainGraphEntry.NAME)],
                input=jg_cube_base.CubeInput(
                    use_new_format=True,
                    strip_binaries=True,
                ),
            )
            graph.add(build_dj_unity_package)

            build_dj_unity_reader_package = jg_cube_build.YaPackage2(
                name="build_dj_unity_reader_package",
                title="Build DJ Unity Reader Package",
                packages=["dj/unity/devops/profile_reader_package.json"],
                resource_types=["DJ_UNITY_PROFILE_READER_PACKAGE"],
                use_compression=False,
                needs=[graph.get(jg_cube_dummy.RMMainGraphEntry.NAME)],
                input=jg_cube_base.CubeInput(
                    use_new_format=True,
                    strip_binaries=True,
                    raw_package=True,
                    raw_package_path="package",
                ),
            )
            graph.add(build_dj_unity_reader_package)

            release_dj_unity_reader_package_to_prestable = jg_cube_release.ReleaseRmComponent2(
                name="release_dj_unity_reader_package_to_prestable",
                title="Release DJ Unity Profile Reader Package to Prestable",
                component_name=self.component_name,
                where_to_release=rm_const.ReleaseStatus.prestable,
                manual=False,
                input=jg_cube_base.CubeInput(
                    component_resources={
                        "dj_unity_profile_reader_package": build_dj_unity_reader_package.output.resources["DJ_UNITY_PROFILE_READER_PACKAGE"].first().id,
                    },
                    deploy_system=rm_const.DeploySystem.sandbox.name,
                ),
                needs=[build_dj_unity_reader_package],
            )
            graph.add(release_dj_unity_reader_package_to_prestable)

            run_dj_unity_acceptance = jg_cube_base.Cube(
                name="run_dj_unity_acceptance",
                title="Run DJ Unity Acceptance SB Task",
                task="projects/adv_machine/dj_unity/dj_unity_acceptance",
                input=jg_cube_base.CubeInput(
                    package_resource=build_dj_unity_package.output.resources["DJ_UNITY_PACKAGE"].first().id,
                    release_number=rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                ),
                needs=[build_dj_unity_package],
            )
            graph.add(run_dj_unity_acceptance)

            skip_dj_unity_acceptance = jg_cube_dummy.Dummy(
                name="skip_dj_unity_acceptance",
                title="Skip DJ Unity Acceptance",
                manual=True,
                needs=[build_dj_unity_package]
            )
            graph.add(skip_dj_unity_acceptance)

            dj_unity_acceptance = jg_cube_dummy.Dummy(
                name="dj_unity_acceptace",
                title="DJ Unity Acceptance",
                needs=[
                    run_dj_unity_acceptance,
                    skip_dj_unity_acceptance
                ],
                needs_type=jg_cube_base.CubeNeedsType.ANY,
            )
            graph.add(dj_unity_acceptance)

            check_tests = jg_cube_dummy.Dummy(
                name="check_tests",
                title="Check DJ Unity Acceptance",
                manual=True,
                needs=[
                    release_dj_unity_reader_package_to_prestable,
                    dj_unity_acceptance,
                ]
            )
            graph.add(check_tests)

            run_dj_unity_release_processes = jg_cube_base.Cube(
                name="run_dj_unity_release_processes",
                title="Run DJ Unity Release Processes",
                task="projects/adv_machine/dj_unity/dj_unity_release_processes",
                input=jg_cube_base.CubeInput(
                    package_resource=build_dj_unity_package.output.resources["DJ_UNITY_PACKAGE"].first().id,
                ),
                needs=[check_tests],
            )
            graph.add(run_dj_unity_release_processes)

            release_dj_unity_package = jg_cube_release.ReleaseRmComponent2(
                name="release_dj_unity_package",
                title="Release DJ Unity Package to Stable",
                component_name=self.component_name,
                where_to_release=rm_const.ReleaseStatus.stable,
                manual=False,
                input=jg_cube_base.CubeInput(
                    component_resources={
                        "dj_unity_package": build_dj_unity_package.output.resources["DJ_UNITY_PACKAGE"].first().id,
                    },
                    deploy_system=rm_const.DeploySystem.sandbox.name,
                ),
                needs=[check_tests],
            )
            graph.add(release_dj_unity_package)

            release_dj_unity_reader_package_to_stable = jg_cube_release.ReleaseRmComponent2(
                name="release_dj_unity_reader_package_to_stable",
                title="Release DJ Unity Profile Reader Package to Stable",
                component_name=self.component_name,
                where_to_release=rm_const.ReleaseStatus.stable,
                manual=False,
                input=jg_cube_base.CubeInput(
                    component_resources={
                        "dj_unity_profile_reader_package": build_dj_unity_reader_package.output.resources["DJ_UNITY_PROFILE_READER_PACKAGE"].first().id,
                    },
                    deploy_system=rm_const.DeploySystem.sandbox.name,
                ),
                needs=[check_tests],
            )
            graph.add(release_dj_unity_reader_package_to_stable)

            return graph

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            assignee = "eugeninic"
            queue = "DJUNITYRELEASES"
            summary_template = "DJ Unity Release {}"
            followers = ["eugeninic", "rudolf"]
            workflow = rm_const.Workflow.BETA_TEST
            add_commiters_as_followers = False

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        dirs = ["dj/unity"]
        wiki_page = "thelenta/djunity/Releases/"

    class Releases(cfg.ReferenceCIConfig.Releases):
        deploy_system = rm_const.DeploySystem.sandbox
        allow_robots_to_release_stable = True
        main_release_flow_branch_auto_start = False

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="dj_unity_package",  # this is released to hitman synchronously in on_release task method
                    data=ri.SandboxResourceData("DJ_UNITY_PACKAGE", ttl=180),
                    deploy_infos=[ri.SandboxInfo()]  # so, use SandboxInfo to understand prod version
                ),
                ri.ReleasableItem(
                    name="dj_unity_profile_reader_package",
                    data=ri.SandboxResourceData("DJ_UNITY_PROFILE_READER_PACKAGE", ttl=180),
                    deploy_infos=[ri.NannyDeployInfo(
                        ri.DeployService("dj_unity_profile_reader_{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                    )],
                )
            ]
