# -*- coding: utf-8 -*-

from sandbox.projects.common.constants import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class DriveCfg(cfg.ReferenceBranchedConfig):
    name = "drive"
    display_name = "Yandex.Drive backend"
    responsible = "svshevtsov"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        new_task_owner = "EXTMAPS"
        trunk_task_owner = "EXTMAPS"
        testenv_db_owners = [
            "svshevtsov",
            "rureggaeton",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                out_resources = {
                    "YA_DRIVE_BACKEND": 14,
                    "YA_DRIVE_BACKEND_CONFIG_ADMIN": 14,
                    "YA_DRIVE_BACKEND_CONFIG_CHAT": 14,
                    "YA_DRIVE_BACKEND_CONFIG_PRESTABLE": 14,
                    "YA_DRIVE_BACKEND_CONFIG_PRODUCTION": 14,
                    "YA_DRIVE_BACKEND_CONFIG_QA": 14,
                    "YA_DRIVE_BACKEND_CONFIG_ROBOT": 14,
                    "YA_DRIVE_BACKEND_CONFIG_SERVICE": 14,
                    "YA_DRIVE_BACKEND_CONFIG_TESTING": 14,
                    "YA_DRIVE_BACKEND_CONFIG_LEASING": 14,
                    "YA_DRIVE_BACKEND_CONFIG_LEASING_TESTING": 14,
                    "YA_DRIVE_BACKEND_CONFIG_LEASING_PRESTABLE": 14,
                    "YA_DRIVE_BACKEND_CONFIG_MAAS": 14,
                    "YA_DRIVE_BACKEND_ENVIRONMENT": 14,
                    "YA_DRIVE_DEVOPS_CLI": 14,
                    "YA_DRIVE_TELEMATICS": 14,
                    "YA_DRIVE_TELEMATICS_CONFIGS": 14,
                    "YA_DRIVE_TELEMATICS_CONFIG_PRESTABLE": 14,
                    "YA_DRIVE_TELEMATICS_CONFIG_STABLE": 14,
                    "YA_DRIVE_TELEMATICS_CONFIG_TESTING": 14,
                    "YA_DRIVE_TELEMATICS_CONFIG_WIALON": 14,
                }
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_DRIVE",
                        out=out_resources,
                        ctx={
                            "target_resources": list(out_resources.keys()),
                            "build_system": sandbox_constants.SEMI_DISTBUILD_BUILD_SYSTEM,
                            "build_type": "release",
                            "use_aapi_fuse": True,
                            "use_arc_instead_of_aapi": True,
                            "ya_yt_proxy": "hahn",
                            "ya_yt_dir": "//home/carsharing/build_cache",
                            "ya_yt_store_threads": 16,
                        }
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage, release_tag in [
                    (rm_const.ReleaseStatus.stable, None),
                    (rm_const.ReleaseStatus.stable, "ADMIN"),
                    (rm_const.ReleaseStatus.stable, "CHAT"),
                    (rm_const.ReleaseStatus.stable, "LEASING"),
                    (rm_const.ReleaseStatus.stable, "PRODUCTION"),
                    (rm_const.ReleaseStatus.stable, "ROBOT"),
                    (rm_const.ReleaseStatus.stable, "SERVICE"),
                    (rm_const.ReleaseStatus.prestable, None),
                    (rm_const.ReleaseStatus.testing, None),
                    (rm_const.ReleaseStatus.testing, "QA"),
                ]:
                    release_tag_parameter = release_tag.lower() if release_tag else "none"
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            task_name="RELEASE_RM_COMPONENT_2",
                            release_to=release_stage,
                            release_item=release_tag,
                            job_params={
                                "apiargs": {
                                    "kill_timeout": 15 * 60,  # 15 min
                                },
                                "ctx": {
                                    "deploy_system": rm_const.DeploySystem.nanny.name,
                                    "additional_release_parameters": {
                                        "release_tag": release_tag_parameter,
                                    }
                                }
                            },
                            job_arrows=[
                                jg_job_triggers.JobTriggerBuild([
                                    jg_job_data.ParentDataDict("component_resources", "backend", "YA_DRIVE_BACKEND"),
                                ]),
                                jg_job_triggers.JobTriggerNewTag([
                                    jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                    jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                ]),
                            ]
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            release_item=release_tag,
                        )
                    )
                return release_part

    class Releases(cfg.ReferenceBranchedConfig.Releases):

        allow_old_releases = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="backend",
                    data=ri.SandboxResourceData("YA_DRIVE_BACKEND"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("drive_backend_admin"),
                                ri.DeployService("drive_backend_chat"),
                                ri.DeployService("drive_backend_service_app"),
                                ri.DeployService("drive_backend_leasing"),
                                ri.DeployService("drive_backend_stable"),
                                ri.DeployService("rtline_drive_frontend_robot")
                            ],
                            stage=rm_const.ReleaseStatus.stable,
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("rtline_drive_frontend_testing"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("rtline_drive_frontend_prestable"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("rtline_drive_frontend_qa"),
                                ri.DeployService("rtline_drive_frontend_st")
                            ],
                            stage="qa"
                        ),
                    ],
                ),
                ri.ReleasableItem(
                    name="telematics_server",
                    data=ri.SandboxResourceData("YA_DRIVE_TELEMATICS"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            ri.DeployService("rtline_drive_telematics_server"),
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("rtline_drive_telematics_prestable_server"),
                            ],
                            stage=rm_const.ReleaseStatus.testing  # this is not a mistake!
                        ),
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("rtline_drive_telematics_server_2"),
                            ],
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                    ],
                ),
            ]

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            """
            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            assignee = "svshevtsov"
            queue = "DRIVEBACK"
            summary_template = "Yandex.Drive release {}"
            components = "drive_release"
            followers = [
                "svshevtsov",
                "crucian",
                "rureggaeton",
                "yakuninv",
                "dbarbashin",
            ]
            ticket_type = "Release"
            tags = [
                "release-rm-task",
                rm_const.RMNames.DRIVE,
            ]
            use_task_author_as_assignee = True
            hide_commits_under_cut = True
            notify_on_deploy_to_feature_st_tickets = frozenset(["stable"])
            important_changes_limit = 1000

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        """
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """
        observed_paths = [
            "arcadia/drive/backend",
            "arcadia/drive/library/cpp",
            "arcadia/drive/telematics",
            "arcadia/rtline/library",
            "arcadia/rtline/util",
        ]
        wiki_page = ""
