# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class DWHCfg(cfg.ReferenceBranchedConfig):

    name = "dwh"
    display_name = "DWH"
    responsible = "estarchak"

    class MergesCfg(cfg.ReferenceBranchedConfig.MergesCfg):
        never_merge_to_released_branches = False
        number_last_branches_to_merge = 4

        permissions = cfg.MergePermissions(
            permission_type=rm_const.PermissionType.ALLOWED,
            people_groups=cfg.PeopleGroups(
                staff_groups=["yandex_infra_int_automation_billing_reports"],
                abc_services=[cfg.Abc(component_id=2668, role_id=None)],
                logins={"srg91", "estarchak", "shorrty", "robot-srch-releaser"},
            ),
        )

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="dwh_deb",
                    data=ri.SandboxResourceData("DWH_DEB"),
                ),
            ]

        allow_old_releases = True

        release_followers_permanent = ['estarchak', 'shorrty', 'srg91']

        wait_for_deploy_time_sec = 30 * 60  # 30 min

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):

        trunk_task_owner = "BILLING-CI"

        testenv_db_owners = ['estarchak', 'shorrty', 'srg91']

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                """
                    Part of job graph for Testenv with jobs in branch, i.e. tests, builds.
                    :return: list with jobs
                """
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name='YA_PACKAGE',
                        ctx={
                            "use_aapi_fuse": True,
                            "aapi_fallback": True,
                            "packages": "billing/dwh/pkg.json",
                            "package_type": "debian",
                            "publish_package": "True",
                            "key_user": "robot-billing-ci",
                            "publish_to": "yandex-trusty",
                            "use_new_format": True,
                            "resource_type": "DWH_DEB",  # имя ресурса в результате выполнения YA_PACKAGE
                        },
                        out={"DWH_DEB": 10},
                        job_arrows=(                                          # Arrows to other jobs
                            jg_job_triggers.JobTriggerNewTag(                 # Arrow to job NewTag
                                parent_job_data=(                             # Fields to get from NewTag job and put in Build job
                                    # Get "scope_number" from Context and put in "release_number" input field. Override means that we already have this field as default, and we want to override it.
                                    jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                                    jg_job_data.ParentDataId("tag"),          # Put NewTag task id in input field "tag"
                                ),
                            )
                        ),
                    ),
                )
                return branch_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        use_startrek = True

        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = [
                "estarchak@yandex-team.ru",
                "srg91@yandex-team.ru",
                "shorrty@yandex-team.ru"
            ]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "estarchak"
            queue = "DWH"
            summary_template = "DWH релиз: 5.{}"
            followers = ['estarchak', 'shorrty', 'srg91']
            hide_commits_under_cut = True
            nanny_reports = False
            important_changes_limit = 1000

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        dirs = ["arcadia/billing/dwh"]
        wiki_page = ""

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        tag_folder_template = "{branch_num}.{tag_num}"
        tag_folder_pattern = r"([0-9]+)\.([0-9]+)"
