# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class EmsCfg(configs.ReferenceCIConfig):
    name = "ems"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="ems"),
        login="ilyusha",
    )

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "KOSHER_YA_MAKE"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/ab_testing/scripts/ems"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "AB-TESTING"

        ya_make_abs_paths_glob = [
            "quality/ab_testing/scripts/ems/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="ems",
                    build_data=ri.BuildData(
                        target="quality/ab_testing/scripts/ems/bin",
                        artifact="quality/ab_testing/scripts/ems/bin/ems",
                    ),
                    data=ri.SandboxResourceData("ABT_EMS_EXECUTABLE"),
                    deploy_infos=[
                        ri.single_nanny_service("testing_ems", stage=rm_const.ReleaseStatus.testing),
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("production_ems{suffix}_{dc}".format(suffix=suffix, dc=datacenter))
                                for suffix in ("", "_dataset")
                                for datacenter in ("vla", "man", "sas")
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        )
                    ]
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "quality/ab_testing/scripts/ems",
        ]
