# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class ExpadmCfg(configs.ReferenceCIConfig):
    name = "expadm"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="expadm"),
        login='ilyusha'
    )

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "projects/ab_testing/build_experiments_adminka"

        def _get_build_cube(self, graph):
            targets = []
            artifacts = []
            source_artifacts = []
            resource_types = []

            for releasable_item in self.suitable_releasable_items:
                targets.append(releasable_item.build_data.target)
                if releasable_item.build_data.is_source:
                    source_artifacts.append(releasable_item.build_data.artifact)
                else:
                    artifacts.append(releasable_item.build_data.artifact)
                resource_types.append(releasable_item.data.resource_type)

            return build_cubes.YaMakeBuildCubeBase(
                name=self.build_cube_name,
                task=self.build_task,
                targets=targets,
                artifacts=artifacts,
                source_artifacts=source_artifacts,
                resource_types=resource_types,
                input=jg_cube.CubeInput(
                    checkout_arcadia_from_url="${tasks.new_tag.svn_data.svn_paths.tag}/arcadia",
                ),
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/ab_testing/scripts/adminka"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "AB-TESTING"

        ya_make_abs_paths_glob = [
            "quality/ab_testing/scripts/adminka/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):

        main_release_flow_branch_auto_start = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="experiments_adminka",
                    build_data=ri.BuildData(
                        target="quality/ab_testing/scripts/adminka",
                        artifact="quality/ab_testing/scripts/adminka",
                    ),
                    data=ri.SandboxResourceData("EXPERIMENTS_ADMINKA"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            ri.DeployService("production_expadm_yp_{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                        ),
                        ri.single_nanny_service("testing_expadm_yp", stage=rm_const.ReleaseStatus.testing)
                    ]
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["primorial"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "primorial"
            queue = "EXPADMREL"
            dev_queue = "USEREXP"
            summary_template = u"Релиз админки из expadm/stable-{}"
            components = "Adminka"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "ajkon",
                "alexfilatov",
                "buryakov",
                "ilyusha",
                "primorial",
                "samhan",
                "valgushev",
                "leftmain",
                "sharamed",
                "conterouz",
            ]
            add_commiters_as_followers = True
            write_merges_in_table = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "serp/experiments/20/adminka/releases/history/"
        observed_paths = [
            "arcadia/quality/ab_testing/scripts/adminka",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 302
