# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.run_stage as jg_run
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri


def _build_job_params():
    return {
        "apiargs": {
            "requirements": {
                "disk_space": 30 * (1024 ** 3),  # 30 GB
                "ram": 2 * (1024 ** 3),  # 2 GB
            },
        },
    }


class ExpdaemonCfg(configs.ReferenceBranchedConfig):

    name = "expdaemon"
    responsible = "valgushev"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "expdaemon_release_trunk"
        trunk_task_owner = "AB-TESTING"
        branch_db_template = "expdaemon-release-stable-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):

            new_tag_should_wait_for_release_ticket = True

            @property
            def _trunk_part(self):
                this_trunk_part = [
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_ABT_EXP_DAEMON",
                        build_item="BACKEND_TRUNK",
                        out={
                            "EXP_DAEMON_EXECUTABLE": 90,
                        },
                        job_params=_build_job_params(),
                        add_arcadia_to_arcadia_url_value=False,
                        job_arrows=[
                            jg_arrows.ParamsData(
                                input_key=common_const.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: "arcadia:/arc/trunk/arcadia@{revision}".format(
                                    revision=x.revision,
                                ),
                                override=True,
                            ),
                        ],
                    ),
                    jg_release.JobGraphElementReleaseBase(
                        release_to=rm_const.ReleaseStatus.unstable,
                        release_item="BACKEND_TRUNK",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                        },
                        wait_for_deploy=True,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BACKEND_TRUNK",
                                parent_job_data=jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "exp_daemon_executable",
                                    "EXP_DAEMON_EXECUTABLE",
                                ),
                            ),
                        ),
                    ),
                    jg_run.JobGraphElementRunTrunkCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "SHOOT_HTTP_BACKEND_TRUNK",
                        },
                        ctx={
                            "nanny_service": "load_testing_uaas",
                            "override_nanny_port": "80",
                            "use_public_tanks": True,
                            "config_source": "arcadia",
                            "config_arc_path": "quality/ab_testing/exp_daemon/load_testing/conf_http.yaml",
                            "ammo_source": "in_config",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRelease(
                                job_name_parameter="BACKEND_TRUNK__UNSTABLE",
                            ),
                        ),
                    ),
                    jg_run.JobGraphElementRunTrunkCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "SHOOT_APPHOST_NEH_BACKEND_TRUNK",
                        },
                        ctx={
                            "nanny_service": "load_testing_uaas",
                            "override_nanny_port": "81",
                            "use_public_tanks": True,
                            "config_source": "arcadia",
                            "config_arc_path": "quality/ab_testing/exp_daemon/load_testing/conf_apphost_neh.yaml",
                            "ammo_source": "in_config",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRun(
                                job_name_parameter="SHOOT_HTTP_BACKEND_TRUNK",
                            ),
                        ),
                    ),
                    jg_run.JobGraphElementRunTrunkCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "SHOOT_APPHOST_GRPC_BACKEND_TRUNK",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "nanny_service": "load_testing_uaas",
                            "override_nanny_port": "82",
                            "use_public_tanks": True,
                            "config_source": "arcadia",
                            "config_arc_path": "quality/ab_testing/exp_daemon/load_testing/conf_apphost_grpc.yaml",
                            "ammo_source": "in_config",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRun(
                                job_name_parameter="SHOOT_APPHOST_NEH_BACKEND_TRUNK",
                            ),
                        ),
                    ),
                ]

                return this_trunk_part + super(self.__class__, self)._trunk_part

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                package = "quality/ab_testing/exp_daemon/pkg/pkg.json"

                branch_part += (
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        build_item="EXECUTABLE",
                        task_name="BUILD_ABT_EXP_DAEMON",
                        job_params=_build_job_params(),
                        out={"EXP_DAEMON_EXECUTABLE": 90},
                    ),
                    jg_build.JobGraphElementBuildBranched(
                        build_item="DEBIAN_PACKAGE",
                        task_name="YA_PACKAGE",
                        job_params=_build_job_params(),
                        ctx={
                            common_const.USE_AAPI_FUSE: True,
                            common_const.USE_ARC_INSTEAD_OF_AAPI: False,
                            common_const.ALLOW_AAPI_FALLBACK: True,

                            "packages": package,
                            "package_type": "debian",
                            "resource_type": "YA_PACKAGE",

                            common_const.STRIP_BINARIES: True,
                            "create_debug_packages": True,

                            "publish_package": True,
                            "multiple_publish": True,
                            "publish_to_mapping": {
                                package: "yandex-xenial;yandex-bionic"
                            },
                        },
                        out={"YA_PACKAGE": 30},
                    ),
                    jg_run.JobGraphElementRunBranchCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "SHOOT_HTTP_BACKEND_RELEASE",
                        },
                        ctx={
                            "nanny_service": "load_testing_uaas",
                            "override_nanny_port": "80",
                            "use_public_tanks": True,
                            "config_source": "arcadia",
                            "config_arc_path": "quality/ab_testing/exp_daemon/load_testing/conf_http.yaml",
                            "ammo_source": "in_config",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="config_add_parameters",
                                        output_key="release_ticket",
                                        transform=lambda x, params: "-o uploader.task={}".format(x)
                                    ),
                                )
                            ),
                        ),
                    ),
                    jg_run.JobGraphElementRunBranchCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "SHOOT_APPHOST_NEH_BACKEND_RELEASE",
                        },
                        ctx={
                            "nanny_service": "load_testing_uaas",
                            "override_nanny_port": "81",
                            "use_public_tanks": True,
                            "config_source": "arcadia",
                            "config_arc_path": "quality/ab_testing/exp_daemon/load_testing/conf_apphost_neh.yaml",
                            "ammo_source": "in_config",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRun(
                                job_name_parameter="SHOOT_HTTP_BACKEND_RELEASE",
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="config_add_parameters",
                                        output_key="release_ticket",
                                        transform=lambda x, params: "-o uploader.task={}".format(x)
                                    ),
                                )
                            ),
                        ),
                    ),
                    jg_run.JobGraphElementRunBranchCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "SHOOT_APPHOST_GRPC_BACKEND_RELEASE",
                        },
                        ctx={
                            "nanny_service": "load_testing_uaas",
                            "override_nanny_port": "82",
                            "use_public_tanks": True,
                            "config_source": "arcadia",
                            "config_arc_path": "quality/ab_testing/exp_daemon/load_testing/conf_apphost_grpc.yaml",
                            "ammo_source": "in_config",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRun(
                                job_name_parameter="SHOOT_APPHOST_NEH_BACKEND_RELEASE",
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="config_add_parameters",
                                        output_key="release_ticket",
                                        transform=lambda x, params: "-o uploader.task={}".format(x)
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerRelease(job_name_parameter="unstable"),
                        ),
                    ),
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.stable, rm_const.ReleaseStatus.testing]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="EXECUTABLE",
                                    parent_job_data=jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "exp_daemon_executable",
                                        "EXP_DAEMON_EXECUTABLE",
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="DEBIAN_PACKAGE",
                                ),
                            ),
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )

                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.unstable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="EXECUTABLE",
                                parent_job_data=jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "exp_daemon_executable",
                                    "EXP_DAEMON_EXECUTABLE",
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DEBIAN_PACKAGE",
                            ),
                        ),
                    )
                )

                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.unstable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerRun(
                                job_name_parameter="SHOOT_APPHOST_GRPC_BACKEND_RELEASE",
                            ),
                        ),
                    )
                )

                return release_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="exp_daemon_executable",
                    data=ri.SandboxResourceData("EXP_DAEMON_EXECUTABLE"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [ri.DeployService("production_uaas_{}".format(i)) for i in rm_const.ALL_LOCATIONS],
                        ),
                        ri.single_nanny_service("testing_usersplit", stage=rm_const.ReleaseStatus.testing),
                        ri.single_nanny_service("load_testing_uaas", stage=rm_const.ReleaseStatus.unstable),
                    ]
                ),
            ]
        release_followers_permanent = [
            "valgushev",
        ]
        wait_for_deploy_time_sec = 600  # 10 min

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["valgushev"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "valgushev"
            queue = "EXPDAEMONREL"
            dev_queue = "USEREXP"
            summary_template = u"Релиз exp демона из exp_daemon/stable-{}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "ajkon",
                "alexfilatov",
                "buryakov",
                "ilyusha",
                "primorial",
                "rkam",
                "samhan",
                "timurguryev",
                "valgushev",
                "leftmain",
                "sharamed",
                "conterouz",
            ]
            add_commiters_as_followers = True
            write_merges_in_table = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "users/atayan1/Relizy-razbivalki/"
        observed_paths = [
            "arcadia/quality/ab_testing/exp_daemon",
            "arcadia/quality/ab_testing/usersplit_lib",
        ]
