# -*- coding: utf-8 -*-

from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class FaviconCfg(configs.ReferenceCIConfig):
    name = "favicon"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="favicon"),
        login="niknik"
    )
    robot="robot-favicon"

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "projects/jupiter/jupiter_ya_make"

        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.input.update(**{
                sandbox_constants.DEFINITION_FLAGS_KEY: "-DDEBUGINFO_LINES_ONLY=yes",
                sandbox_constants.YA_YT_DIR: "//home/jupiter/yamake_cache",
                sandbox_constants.YA_YT_PROXY: "arnold.yt.yandex.net",
                sandbox_constants.YA_YT_PUT: True,
                sandbox_constants.YA_YT_STORE: True,
                sandbox_constants.YA_YT_TOKEN_VAULT_NAME: "jupiter_yt_token",
                sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: "JUPITER"
            })
            return build

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "robot/favicon"
        secret = "sec-01crfx4hcpd573dvjx2a1kf2zb"
        sb_owner_group = "JUPITER"

        # включаем graph- и dir-discovery по этим путям
        ya_make_abs_paths_glob = [
            "robot/favicon/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 16

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="favicon_cm_binaries",
                    build_data=ri.BuildData(
                        target="robot/favicon/packages/cm_binaries"
                    ),
                    data=ri.SandboxResourceData("FAVICON_CM_BINARIES"),
                    deploy_infos=[
                        ri.single_nanny_service("favicon_cm")
                    ]
                ),
                ri.ReleasableItem(
                    name="favicon_cm_configs",
                    build_data=ri.BuildData(
                        target="robot/favicon/packages/cm_instances/production"
                    ),
                    data=ri.SandboxResourceData("FAVICON_CM_CONFIGS"),
                    deploy_infos=[
                        ri.single_nanny_service("favicon_cm")
                    ]
                ),
                ri.ReleasableItem(
                    name="favicon_dolbilo_binaries",
                    build_data=ri.BuildData(
                        target="robot/favicon/packages/dolbilo"
                    ),
                    data=ri.SandboxResourceData("FAVICON_DOLBILO_BINARIES"),
                    deploy_infos=[]
                ),
                ri.ReleasableItem(
                    name="favicon_http_daemon",
                    build_data=ri.BuildData(
                        target="robot/favicon/packages/runtime_binaries"
                    ),
                    data=ri.SandboxResourceData("FAVICON_HTTP_DAEMON"),
                    deploy_infos=[]
                ),
                ri.ReleasableItem(
                    name="favicon_make_wad_index",
                    build_data=ri.BuildData(
                        target="robot/favicon/packages/make_wad_index"
                    ),
                    data=ri.SandboxResourceData("FAVICON_MAKE_WAD_INDEX"),
                    deploy_infos=[]
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Mail(configs.ReferenceCIConfig.Notify.Mail):
            mailing_list = [
                "search-components-releases@yandex-team.ru",
                "jupiter-alerts@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["gemini_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "niknik"
            queue = "FAVICONRELEASE"
            dev_queue = "FAVICON"
            summary_template = u"Favicon {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = []
            add_commiters_as_followers = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "robot/favicon/changelogs/"
        dirs = [
            "robot/favicon",
        ]
        review_groups = [
            "jupiter",
        ]
