# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class FindurlWorkerCfg(configs.ReferenceCIConfig):
    name = "findurl_worker"  # Id, not human-readable
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="findurl"),
        login="robot-findurl",
    )

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "KOSHER_YA_MAKE"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "search/tools/fast_findurl/worker"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "FINDURL"

        ya_make_abs_paths_glob = [
            "search/tools/fast_findurl/**",
        ]  # How to find commits

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="findurl_worker",
                    data=ri.SandboxResourceData("FINDURL_WORKER", ttl=180),
                    deploy_infos=[
                        ri.single_nanny_service("findurl_over_yt"),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "robot-findurl",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "i024"
            queue = "FINDURL"
            dev_queue = "FINDURL"
            summary_template = u"Приемка findurl worker {}"
            workflow = {}
            followers = [
                "i024",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "findurl/releases/"
        dirs = [
            "search",
        ]
