# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components.config_core.jg import base as jg_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
import os.path


class FintechBackendCICfgBase(cfg.ReferenceCIConfig):
    ctypes = [
        rm_const.ReleaseStatus.testing,
        rm_const.ReleaseStatus.prestable,
        rm_const.ReleaseStatus.stable
    ]

    class ReleaseItem:
        def __init__(self, title,
                     resource_types=None, resource_type=None,
                     packages=None, package=None,
                     targets=None, target=None,
                     sources=None, source=None
                     ):
            def _arrray(item, arr):
                if arr is None:
                    return [] if item is None else [item]
                return arr

            self.title = title
            self.resource_types = _arrray(resource_type, resource_types)
            self.packages = _arrray(package, packages)
            self.targets = _arrray(target, targets)
            self.sources = _arrray(source, sources)

    class JG(jg_base.BaseReleaseMachineJobGraph):

        def _add_build_cube(self, graph, rel_item):
            if len(rel_item.packages) > 0:
                build_cube = build_cubes.KosherYaPackage(
                    name='build_' + rel_item.title,
                    title='Build {}'.format(rel_item.title),
                    packages=rel_item.packages,
                    resource_types=rel_item.resource_types,
                    use_compression=False,
                    needs=[
                        graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                    ]
                )
            else:
                build_cube = build_cubes.KosherYaMake(
                    name='build_' + rel_item.title,
                    title='Build {}'.format(rel_item.title),
                    resource_types=[rt for rt in rel_item.resource_types],
                    source_artifacts=rel_item.sources,
                    artifacts=rel_item.targets,
                    targets=[os.path.dirname(target) for target in rel_item.targets],
                    needs=[
                        graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                    ]
                )
            graph.add(build_cube)
            return build_cube

        def _add_release_cube(self, graph, build_cube, rel_item, ctype, manual=True, needs=[], startrek=True):
            rel_cube = release_cubes.ReleaseRmComponent2(
                name='release_{}_{}'.format(rel_item.title, ctype),
                title='{} to {}'.format(rel_item.title, ctype),
                manual=manual,
                where_to_release=ctype,
                component_name=self.component_name,
                input=jg_cube.CubeInput(
                    component_resources={
                        '{}_{}'.format(rel_item.title, resource_type): build_cube.output.resources[
                            resource_type].first().id
                        for resource_type in rel_item.resource_types
                    },
                    deploy_system=rm_const.DeploySystem.ya_deploy.name,
                    wait_for_deploy=True,
                    wait_for_deploy_attempts=360,
                    wait_for_deploy_time_sec=120,
                ),
                needs=needs if needs else [build_cube],
            )
            if not startrek:
                rel_cube.input.update(major_release_num=None, minor_release_num=None)
            graph.add(rel_cube)
            return rel_cube

        def _add_build_and_release(self, graph, rel_item, ctypes, manual=True, startrek=True):
            build_cube = self._add_build_cube(graph, rel_item)
            return [
                self._add_release_cube(graph, build_cube, rel_item, ctype, manual, startrek=startrek)
                for ctype in ctypes
            ]

        def _add_skip_cubes(self, graph, needs, skip_finish, name):
            skip = skip_finish if isinstance(skip_finish, list) else [skip_finish]
            skip_cube = dummy_cubes.Dummy(
                name="skip_{}".format(name),
                title="Skip {}".format(name),
                manual=True,
                needs=needs if isinstance(needs, list) else [needs]
            )
            graph.add(skip_cube)

            if len(skip) > 1:
                done_cube = dummy_cubes.Dummy(
                    name="done_{}".format(name),
                    title="Done {}".format(name),
                    manual=False,
                    needs=skip
                )
                graph.add(done_cube)
            else:
                done_cube = skip[0]

            finish_cube = dummy_cubes.Dummy(
                name="finish_{}".format(name),
                title="Finish_{}".format(name),
                manual=False,
                needs=[skip_cube, done_cube],
                needs_type=jg_cube.CubeNeedsType.ANY
            )
            graph.add(finish_cube)
            return finish_cube

        def _add_manual_skip_cubes(self, graph, release_cubes):
            if len(release_cubes) < 2:
                return graph
            self._add_skip_cubes(graph, graph.get(dummy_cubes.RMMainGraphEntry.NAME), release_cubes, "all")
            return graph

        def _trunk(self, rel_items):
            graph = graph_base.Graph([dummy_cubes.RMMainGraphEntry()])
            releases = []
            for rel_item in rel_items:
                releases += self._add_build_and_release(graph,
                                                        rel_item,
                                                        [rm_const.ReleaseStatus.testing],
                                                        manual=False, startrek=False)
            return self._add_manual_skip_cubes(graph, releases)

        def _create_tests_cube(self, needs, ctype, manual=False, title=''):
            return None

        def _add_tests_cube(self, graph, rel_item, needs, ctype):
            last_cube = self._create_tests_cube(needs, ctype, True, rel_item.title)
            if last_cube is None:
                return None
            graph.add(last_cube)
            last_cube = self._add_skip_cubes(graph, needs, last_cube, "tests_{}_{}".format(rel_item.title, ctype))
            startrek_cube = graph.get(internal_cubes.CreateStartrekTicket.NAME)
            if startrek_cube is not None:
                last_cube = internal_cubes.PostChangelogToStartrek(
                    self.component_name,
                    name="post_soxok_{}_{}".format(rel_item.title, ctype),
                    title="post SOXOK",
                    input=jg_cube.CubeInput(
                        comment_marker="<# <!-- TESTS --> #>",
                        issue_key=startrek_cube.output.st_ticket.key,
                        comment_text="Tests for {}.{} !!(green)SOXOK!!".format(
                            rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                            rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM
                        ),
                    ),
                    needs=[
                        startrek_cube,
                        last_cube
                    ]
                )
                graph.add(last_cube)
            return last_cube

        def _add_release_with_tests(self, graph, rel_item, ctypes):
            build_cube = self._add_build_cube(graph, rel_item)
            prev = build_cube
            for ctype in ctypes:
                needs = [prev]
                prev = self._add_release_cube(graph, build_cube, rel_item, ctype, needs=needs)
                prev = self._add_skip_cubes(graph, needs, prev, "release_{}_{}".format(rel_item.title, ctype))
                tests = self._add_tests_cube(graph, rel_item, [prev], ctype)
                if tests is not None:
                    prev = tests
            return [prev]

    class Releases(cfg.ReferenceCIConfig.Releases):
        main_release_flow_branch_auto_start = False

        @property
        def releasable_items(self):
            result = []
            for rel_item in self.all_release_items:
                for resource_type in rel_item.resource_types:
                    name = '{}_{}'.format(rel_item.title, resource_type)
                    result.append(ri.ReleasableItem(
                        name=name,
                        data=ri.SandboxResourceData(resource_type),
                        deploy_infos=[
                            ri.YaDeployInfo(ri.DeployService('{}_{}'.format(name, ctype)), stage=ctype)
                            for ctype in FintechBackendCICfgBase.ctypes
                        ],
                    ))
            return result

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "iddqd",
        ]
