# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.fintech import _common
from sandbox.projects.release_machine.components import configs as cfg

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.common.constants import constants as common_const


class Tests(build_cubes.YaMake2):
    def __init__(self, **kwargs):
        super(Tests, self).__init__(**kwargs)

    @property
    def input_defaults(self):
        result = super(Tests, self).input_defaults
        result.update({
            common_const.YA_TIMEOUT: 5 * 60 * 60,  # 5 hours in seconds
            common_const.DISABLE_TEST_TIMEOUT: True,
            common_const.TESTS_REQUESTED: True,
            common_const.TEST_SIZE_FILTER: 'large',
            common_const.ENV_VARS: 'ENV_PATH=$(vault:file:iddqd:fintech_bnpl_bb_tests)',
            common_const.ALLURE_REPORT: True,
            common_const.TEST_THREADS: 4,
            common_const.TEST_TAG: 'ya:manual',
        })
        return result


class FintechBnplBackendCICfg(_common.FintechBackendCICfgBase):
    name = "fintech_bnpl_backend_ci"
    responsible = cfg.Responsible(abc=cfg.Abc(service_name="bnpl"), login="iddqd")

    bnpl_backend_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='backend',
        resource_type='BNPL_BACKEND',
        target='fintech/bnpl/backend/bnpl',
    )
    bnpl_resources_pack_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='resources_pack',
        resource_types=[
            'FINTECH_BNPL_RESOURCES'
        ],
        package='fintech/bnpl/backend/configs/package_resources.json',
    )
    sm_backend_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='sm_bin',
        resource_type='COMMON_SERVER_SERVICE_MONITOR_BINARY',
        target='kernel/common_server/service_monitor/service_monitor',
    )
    sm_resources_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='sm_cfg',
        resource_type='COMMON_SERVER_SERVICE_MONITOR_CONFIG',
        source='kernel/common_server/service_monitor/configs',
    )
    bnpl_release_items = [bnpl_backend_item, bnpl_resources_pack_item]
    sm_release_items = [sm_backend_item, sm_resources_item]

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "fintech/bnpl/backend"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "FINTECH_BNPL"

        ya_make_abs_paths_glob = [
            "fintech/bnpl/**",
            "fintech/risk/backend/client/**",
            "kernel/common_server/**",
        ]

    class JG(_common.FintechBackendCICfgBase.JG):
        @jg_flow.main_release_flow(title='Bnpl: Brunch everything')
        def release(self):
            graph = super(FintechBnplBackendCICfg.JG, self).release(self)
            releases = self._add_release_with_tests(
                graph,
                FintechBnplBackendCICfg.bnpl_backend_item,
                FintechBnplBackendCICfg.ctypes
            ) + self._add_build_and_release(
                graph,
                FintechBnplBackendCICfg.bnpl_resources_pack_item,
                FintechBnplBackendCICfg.ctypes
            )
            return self._add_manual_skip_cubes(graph, releases)

        @jg_flow.supplementary_release_flow(title='Bnpl: Trunk Binary', filters=[{
            'discovery': 'graph',
            'abs-paths': ['fintech/bnpl/backend/**']
        }])
        def bnpl_binary_trunk(self):
            return self._trunk([FintechBnplBackendCICfg.bnpl_backend_item])

        @jg_flow.supplementary_release_flow(title='Bnpl: Trunk Resources', filters=[{
            'discovery': 'dir',
            'abs-paths': ['fintech/bnpl/backend/configs/**']
        }])
        def bnpl_resources_trunk(self):
            return self._trunk([
                FintechBnplBackendCICfg.bnpl_resources_pack_item,
            ])

        @jg_flow.supplementary_release_flow(title='Service Monitor: Trunk everything', filters=[{
            "discovery": "graph",
            "abs-paths": ["kernel/common_server/service_monitor/**"]
        }, {
            "discovery": "dir",
            "abs-paths": ["kernel/common_server/service_monitor/configs/**"]
        }])
        def sm_trunk(self):
            return self._trunk(FintechBnplBackendCICfg.sm_release_items)

        @jg_flow.supplementary_release_flow(title='Bnpl: Run tests', filters=[{
            'discovery': 'dir',
            'abs-paths': ['fintech/bnpl/backend/**']
        }])
        def bnpl_run_tests(self):
            return graph_base.Graph([self._create_tests_cube([], rm_const.ReleaseStatus.testing)])

        def _create_tests_cube(self, needs, ctype, manual=False, title=''):
            if ctype != rm_const.ReleaseStatus.testing:
                return None
            return Tests(
                name="run_tests_{}_{}".format(title, ctype),
                title="Run tests {}".format(title),
                targets=['fintech/bnpl/backend/bb_tests/remote_bnpl'],
                artifacts=[],
                resource_types=[],
                needs=needs,
                manual=manual,

            )

    class Releases(_common.FintechBackendCICfgBase.Releases):
        @property
        def all_release_items(self):
            return FintechBnplBackendCICfg.bnpl_release_items + FintechBnplBackendCICfg.sm_release_items

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            assignee = "iddqd"
            queue = "FINTECHRELEASE"
            dev_queue = "FINDEV"
            summary_template = u"Fintech BNPL Backend release {}"
            workflow = {}
            followers = [
                "nsofya",
                "iddqd",
                "BNPL"
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "fintech-team/bnpl/backend-changelog"
        dirs = [
            "arcadia/fintech/bnpl/backend/src",
            "arcadia/fintech/risk/backend/client",
            "arcadia/kernel/common_server"
        ]
