# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.fintech import _common
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow


class FintechRiskBackendCfg(_common.FintechBackendCICfgBase):
    name = "fintech_risk_backend"
    responsible = cfg.Responsible(abc=cfg.Abc(service_name="fintech_risk"), login="ivanmorozov")

    risk_backend_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='backend',
        resource_type='FINTECH_RISK_BACKEND',
        target='fintech/risk/backend/src/risk',
    )
    risk_resources_pack_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='resources_pack',
        resource_types=[
            'FINTECH_RISK_RESOURCES_PACK'
        ],
        package='fintech/risk/backend/rtc/package_resources.json',
    )
    risk_release_items = [risk_backend_item, risk_resources_pack_item]

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "fintech/risk/backend"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "FINTECH_RISK"

        ya_make_abs_paths_glob = [
            "fintech/risk/**",
            "kernel/common_server/**"
        ]

    class JG(_common.FintechBackendCICfgBase.JG):
        @jg_flow.main_release_flow(title='RISK ALL: Brunch All')
        def release(self):
            graph = super(FintechRiskBackendCfg.JG, self).release(self)
            releases = self._add_release_with_tests(
                graph,
                FintechRiskBackendCfg.risk_backend_item,
                FintechRiskBackendCfg.ctypes
            ) + self._add_build_and_release(
                graph,
                FintechRiskBackendCfg.risk_resources_pack_item,
                FintechRiskBackendCfg.ctypes
            )
            self._add_manual_skip_cubes(graph, releases)
            return graph

        @jg_flow.supplementary_release_flow(
            title='RISK TESTING: Trunk Binary',
            auto=True,
            filters=[{
                'discovery': 'graph',
                'abs-paths': ['fintech/risk/backend/src/**']
        }])
        def binary_trunk(self):
            return self._trunk([FintechRiskBackendCfg.risk_backend_item])

        @jg_flow.supplementary_release_flow(
            title='RISK TESTING: Trunk Resources',
            auto=True,
            filters=[{
                'discovery': 'dir',
                'abs-paths': [
                    'fintech/risk/backend/configs/**',
                    'fintech/risk/backend/ext_data/**',
                    'fintech/risk/backend/migrations/**',
                ]
        }])
        def resources_trunk(self):
            return self._trunk([
                FintechRiskBackendCfg.risk_resources_pack_item,
            ])

    class Releases(_common.FintechBackendCICfgBase.Releases):
        @property
        def all_release_items(self):
            return FintechRiskBackendCfg.risk_release_items

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            assignee = "ivanmorozov"
            queue = "FINTECHRELEASE"
            dev_queue = "FINDEV"
            summary_template = u"FintechRiskBackend release {}"
            workflow = {}
            followers = [
                "ivanmorozov"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "ivanmorozov/fintech/releases/risk/backend"
        dirs = [
            "arcadia/fintech/risk/backend/src",
            "arcadia/kernel/common_server"
        ]
