# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.fintech import _common
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import run_command as run_command_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
from sandbox.projects.release_machine.core import const as rm_const


class FintechRiskBackendCfg(_common.FintechBackendCICfgBase):
    name = "fintech_risk_backend_linear_scripts"
    responsible = cfg.Responsible(abc=cfg.Abc(service_name="fintech_risk"), login="ivanmorozov")

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "fintech/risk/backend/rtc/linear_scripts"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "FINTECH_RISK"

        ya_make_abs_paths_glob = [
            "fintech/risk/backend/rtc/linear_scripts",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class JG(_common.FintechBackendCICfgBase.JG):
        def _add_write_script(self, name, graph, read_script, needs, add, manual, comment=''):
            last_cube = run_command_cubes.RunCommand(
                name=name,
                title=name,
                needs=needs,
                manual=manual,
                input=cube_base.CubeInput(
                    config={
                        'cmd_line':
                            'TVM_TICKET=`echo $TVM_SECRET | ya tool tvmknife get_service_ticket '
                            'client_credentials -s 2030113 -d 2030113` '
                            'ya tool python fintech/risk/backend/rtc/linear_scripts/import_graph.py ' + add,
                        'fixed_sandbox_resources': [{
                            'key': 'frozen_scripts',
                            'resource_id': read_script.output.resources["OTHER_RESOURCE"].first().id
                        }],
                        'secret_environment_variables': [
                            {
                                'key': 'TVM_SECRET',
                                'secret_spec': {
                                    'uuid': 'sec-01fe11jywe6p4jf0q3hbdngdkq',
                                    'key': 'client_secret'
                                }
                            }
                        ],
                        'arc_mount_config': {
                            'enabled': True
                        }
                    }
                )
            )
            graph.add(last_cube)
            startrek_cube = graph.get(internal_cubes.CreateStartrekTicket.NAME)
            if startrek_cube is not None:
                last_cube = internal_cubes.PostChangelogToStartrek(
                    self.component_name,
                    name="post_sent_{}".format(name),
                    title="Post to startrek {}".format(comment),
                    input=cube_base.CubeInput(
                        comment_marker="<# <!-- Release --> #>",
                        issue_key=startrek_cube.output.st_ticket.key,
                        comment_text="{} for {}.{} !!(green)OK!!".format(
                            comment,
                            rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                            rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM
                        ),
                    ),
                    needs=[
                        startrek_cube,
                        last_cube
                    ]
                )
                graph.add(last_cube)

            return last_cube

        def _add_read_script(self, graph, needs):
            read_script = run_command_cubes.RunCommand(
                name='read_script_from_testing',
                title='Read script from testing',
                needs=needs,
                input=cube_base.CubeInput(
                    config={
                        'cmd_line':
                            'TVM_TICKET=`echo $TVM_SECRET | ya tool tvmknife get_service_ticket '
                            'client_credentials -s 2030111 -d 2030111` '
                            'ya tool python fintech/risk/backend/rtc/linear_scripts/export_graph.py '
                            'fintech/risk/backend/rtc/linear_scripts/frozen_scripts '
                            '$RESULT_RESOURCES_PATH/frozen_scripts',
                        'result_resources': [{
                            'path': 'frozen_scripts',
                            'description': 'Frozen scripts',
                            'compression_type': 'none',
                            'type': 'OTHER_RESOURCE'
                        }],
                        'secret_environment_variables': [
                            {
                                'key': 'TVM_SECRET',
                                'secret_spec': {
                                    'uuid': 'sec-01fe11j5ypbz32kt2m91vamcwp',
                                    'key': 'client_secret'
                                }
                            }
                        ],
                        'arc_mount_config': {
                            'enabled': True
                        }
                    }
                )
            )
            graph.add(read_script)
            return read_script

        def _add_diff_script(self, graph, read_script, needs):
            diff_script = run_command_cubes.RunCommand(
                name='diff_script',
                title='Diff script',
                needs=needs,
                input=cube_base.CubeInput(
                    config={
                        'cmd_line':
                            'TVM_TICKET=`echo $TVM_SECRET | ya tool tvmknife get_service_ticket '
                            'client_credentials -s 2030113 -d 2030113` '
                            'URL="risk-v1.fintech.yandex.net" '
                            'ya tool python fintech/risk/backend/rtc/linear_scripts/export_graph.py '
                            'fintech/risk/backend/rtc/linear_scripts/frozen_scripts old_scripts\n'
                            'mkdir -p $RESULT_RESOURCES_PATH/script_diffs\n'
                            'for SCRIPT in `ls "{new_scripts}"`\n'
                            '   do if [[ -e old_scripts/$SCRIPT ]]\n'
                            '   then\n'
                            '       diff old_scripts/$SCRIPT "{new_scripts}/$SCRIPT" '
                            '       >$RESULT_RESOURCES_PATH/script_diffs/$SCRIPT || echo -n\n'
                            '   else\n'
                            '       echo CREATE >$RESULT_RESOURCES_PATH/script_diffs/$SCRIPT\n'
                            '   fi\n'
                            'done',
                        'fixed_sandbox_resources': [{
                            'key': 'new_scripts',
                            'resource_id': read_script.output.resources["OTHER_RESOURCE"].first().id
                        }],
                        'result_resources': [{
                            'path': 'script_diffs',
                            'description': 'Script diffs',
                            'compression_type': 'none',
                            'type': 'OTHER_RESOURCE',
                            'ci_badge': True
                        }],
                        'secret_environment_variables': [
                            {
                                'key': 'TVM_SECRET',
                                'secret_spec': {
                                    'uuid': 'sec-01fe11jywe6p4jf0q3hbdngdkq',
                                    'key': 'client_secret'
                                }
                            }
                        ],
                        'arc_mount_config': {
                            'enabled': True
                        }
                    }
                )
            )
            graph.add(diff_script)
            return diff_script

        @jg_flow.main_release_flow(title='RISK LINEAR SCRIPTS: All', filters=[{
            'discovery': 'dir',
            'abs-paths': [
                'fintech/risk/backend/rtc/**'
            ]
        }])
        def linear_scripts(self):
            graph = super(FintechRiskBackendCfg.JG, self).release(self)
            read_script = self._add_read_script(graph, needs=[graph.get(dummy_cubes.RMMainGraphEntry.NAME)])
            diff_script = self._add_diff_script(graph, read_script, [read_script])
            write_script = self._add_write_script(
                'import_graphs', graph, read_script, [diff_script],
                manual=False,
                add='import_graphs {frozen_scripts}',
                comment='Import graphs'
            )
            priority = '$( expr {maj} \\* 100 + {min})'.format(
                maj=rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                min=rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM
            )
            prestable = self._add_write_script(
                'frozen_to_prestable', graph, read_script, [write_script],
                manual=True,
                add='upload_frozen {frozen_scripts} ' + priority + ' prestable',
                comment='Upload frozen scripts to prestable'
            )
            qa_approve = dummy_cubes.Dummy(
                name='qa_approve',
                title='QA approve',
                needs=[prestable],
                manual=cube_base.CubeManual(
                    approvers=cfg.responsibility.ABCSelection(service="fintech_risk", scope="testing"),
                )
            )
            graph.add(qa_approve)
            self._add_write_script(
                'frozen_to_stable', graph, read_script, [qa_approve],
                manual=True,
                add='upload_frozen {frozen_scripts} ' + priority + ' prestable,stable',
                comment='Upload frozen scripts to stable'
            )

            return graph

    class Releases(_common.FintechBackendCICfgBase.Releases):
        resources_info = []

        @property
        def all_release_items(self):
            return []

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            assignee = "ivanmorozov"
            queue = "FINTECHRELEASE"
            dev_queue = "FINDEV"
            summary_template = u"FintechRiskBackend release {}"
            workflow = {}
            followers = [
                "ivanmorozov"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "ivanmorozov/fintech/releases/risk/backend/linear_scripts"
        dirs = [
            "fintech/risk/backend/rtc/linear_scripts"
        ]
