# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.fintech import _common
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow


class FintechRiskSourceCfg(_common.FintechBackendCICfgBase):
    name = "fintech_risk_sources"
    responsible = cfg.Responsible(abc=cfg.Abc(service_name="fintech_risk"), login="ivanmorozov")

    risk_source_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='backend',
        resource_type='FINTECH_RISK_SOURCES',
        target='fintech/risk/sources/core/src/risk_source',
    )
    risk_resources_pack_item = _common.FintechBackendCICfgBase.ReleaseItem(
        title='resources_pack',
        resource_types=[
            'FINTECH_RISK_SOURCES_RESOURCES_PACK'
        ],
        package='fintech/risk/sources/core/rtc/package_resources.json',
    )
    risk_release_items = [risk_source_item, risk_resources_pack_item]

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "fintech/risk/sources/core"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "FINTECH_RISK"

        ya_make_abs_paths_glob = [
            "fintech/risk/**",
            "kernel/common_server/**"
        ]

    class JG(_common.FintechBackendCICfgBase.JG):
        @jg_flow.main_release_flow(title='SOURCE ALL: Brunch All')
        def release(self):
            graph = super(FintechRiskSourceCfg.JG, self).release(self)
            releases = []
            for rel_item in FintechRiskSourceCfg.risk_release_items:
                releases += self._add_build_and_release(graph, rel_item, FintechRiskSourceCfg.ctypes)
            self._add_manual_skip_cubes(graph, releases)
            return graph

        @jg_flow.supplementary_release_flow(title='SOURCE TESTING: Trunk Binary', filters=[{
            'discovery': 'graph',
            'abs-paths': ['fintech/risk/sources/core/src/**']
        }])
        def binary_trunk(self):
            return self._trunk([FintechRiskSourceCfg.risk_source_item])

        @jg_flow.supplementary_release_flow(title='SOURCE TESTING: Trunk Resources', filters=[{
            'discovery': 'dir',
            'abs-paths': [
                'fintech/risk/sources/core/configs/**',
                'fintech/risk/backend/ext_data/**',
                'fintech/risk/backend/migrations/**',
            ]
        }])
        def resources_trunk(self):
            return self._trunk([
                FintechRiskSourceCfg.risk_resources_pack_item,
            ])

    class Releases(_common.FintechBackendCICfgBase.Releases):
        @property
        def all_release_items(self):
            return FintechRiskSourceCfg.risk_release_items

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            assignee = "alrakov"
            queue = "FINTECHRELEASE"
            dev_queue = "FINDEV"
            summary_template = u"FintechRiskSource release {}"
            workflow = {}
            followers = [
                "alrakov"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "alrakov/fintech/releases/risk/source"
        dirs = [
            "arcadia/fintech/risk/sources/core/src",
            "arcadia/kernel/common_server"
        ]
