from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import SearchReleasesBuildTestCube
from sandbox.projects.release_machine.components.configs.upper_search.web import SearchIntegrationTestsBundle
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.metrics import SearchLaunchMetricsVideo, SearchLaunchMetricsImages
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base.images import TestE2ETestsImages
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.flags_provider import TestE2ETestsVideoFP
from sandbox.projects.release_machine.components.config_core.jg.cube.base import CubeInput


class FlagsProviderTestsBundle():
    @staticmethod
    def get_bundle(targets, sanitizers, entry_cube, beta_cube, soy_pool):
        """
        Returns list of clickdaemon component tests

        :type targets: List[str]
        :param targets:
            List of targets for ya_make tests

        :type sanitizers: List[str]
        :param sanitizers:
            List of sanitizers for ya_make tests

        :type entry_cube: Cube
        :param entry_cube:
            Build stage entry cube for ya_make tests dependencies

        :type beta_cube: Cube
        :param beta_cube:
            Beta cube for beta tests dependencies

        :type soy_pool: str
        :param soy_pool:
            The name of the soy_pool
        """

        return SearchIntegrationTestsBundle.get_bundle(beta_cube, soy_pool) + [
            SearchReleasesBuildTestCube(
                name="ya_make_test_sanitize_{}".format(sanitizer) if sanitizer else "ya_make_test_sanitize",
                task="KOSHER_YA_MAKE",
                input=CubeInput(
                    targets=";".join(targets),
                    test=True,
                    disable_test_timeout=True,
                    sanitize=sanitizer,
                ),
                needs=[entry_cube],
            ) for sanitizer in sanitizers
        ] + [
            TestE2ETestsImages(beta_cube),
            TestE2ETestsVideoFP(beta_cube),
        ] + [
            SearchLaunchMetricsVideo.by_generate_beta_cube(beta_cube),
            SearchLaunchMetricsImages.by_generate_beta_cube(beta_cube),
        ]
