# -*- coding: utf-8 -*-

from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.helpers.arcadia as rm_arc
from sandbox.projects.release_machine.components.configs.report import SearchIntergationTestBundle


SERVICES = {
    'web': [
        (rm_const.ReleaseStatus.stable, "prestable_flags_provider_sas_web_yp"),
        (rm_const.ReleaseStatus.stable, "production_flags_provider_sas_web_yp"),
        (rm_const.ReleaseStatus.stable, "production_flags_provider_man_web_yp"),
        (rm_const.ReleaseStatus.stable, "production_flags_provider_vla_web_yp"),
        (rm_const.ReleaseStatus.stable, "hamster_flags_provider_sas_web_yp"),
        (rm_const.ReleaseStatus.stable, "hamster_flags_provider_man_web_yp"),
        (rm_const.ReleaseStatus.stable, "hamster_flags_provider_vla_web_yp"),
    ],
    'shared': [
        (rm_const.ReleaseStatus.stable, "production_flags_provider_sas_shared"),
        (rm_const.ReleaseStatus.stable, "production_flags_provider_man_shared"),
        (rm_const.ReleaseStatus.stable, "production_flags_provider_vla_shared"),
        (rm_const.ReleaseStatus.stable, "hamster_flags_provider_sas_shared"),
        (rm_const.ReleaseStatus.stable, "hamster_flags_provider_man_shared"),
        (rm_const.ReleaseStatus.stable, "hamster_flags_provider_vla_shared"),
    ],
}


class FlagsProviderCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "flags_provider"
    responsible = "alex-ersh"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "ws-flags_provider-trunk"
        trunk_task_owner = "REPORT_CORE"
        branch_db_template = "ws-flags_provider-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            default_yamake_task = 'KOSHER_YA_MAKE'

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_FLAGS_PROVIDER_CORE",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key="arcadia_url",
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="arc_url",
                                                output_key="result_path",
                                            ),
                                            jg_job_data.ParentDataCtx(
                                                input_key="arc_rev",
                                                output_key="result_revision",
                                            ),
                                        ),
                                    ),
                                ),
                                transform=rm_arc.construct_arc_url,
                            )
                        ),
                        out={
                            "FLAGS_PROVIDER_BINARY_BUNDLE_RESOURSE_TYPE": 30,
                            "FLAGS_PROVIDER_CONFIG_RESOURSE_TYPE": 30,
                            "FLAGS_PROVIDER_INSTANCE_CTL_RESOURSE_TYPE": 30,
                            "FLAGS_PROVIDER_BINARY_BUNDLE_SHARED": 30,
                            "FLAGS_PROVIDER_INSTANCE_CTL_SHARED": 30,
                            "FLAGS_PROVIDER_CONFIG_SHARED": 30,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="web",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "flags_provider_binary_res_id",
                                        "FLAGS_PROVIDER_BINARY_BUNDLE_RESOURSE_TYPE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "flags_provider_config_res_id",
                                        "FLAGS_PROVIDER_CONFIG_RESOURSE_TYPE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "flags_provider_instancectl_res_id",
                                        "FLAGS_PROVIDER_INSTANCE_CTL_RESOURSE_TYPE",
                                    ),
                                ),
                            ),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="shared",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "shared_flags_provider_binary_res_id",
                                        "FLAGS_PROVIDER_BINARY_BUNDLE_SHARED",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "shared_flags_provider_config_res_id",
                                        "FLAGS_PROVIDER_CONFIG_SHARED",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "shared_flags_provider_instancectl_res_id",
                                        "FLAGS_PROVIDER_INSTANCE_CTL_SHARED",
                                    ),
                                ),
                            ),
                        )
                    )
                )
                for vertical in ['web', 'images', 'video']:
                    branch_part.append(
                        jg_test.JobGraphElementLaunchMetrics(
                            search_subtype=vertical,
                            ctx={
                                "sample_beta": "hamster",
                                "scraper_over_yt_pool": "report_web_priemka",
                                "beta_conf_type": "web",
                                "run_findurl": False,
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerGenerateBeta(
                                    job_name_parameter="web",
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="checked_beta",
                                            output_key="new_beta_url",
                                        ),
                                    )
                                ),
                            )
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementTestTdiAndRearr(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="web",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="checked_beta",
                                        output_key="new_beta_url",
                                    )
                                )
                            )
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="web",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="hermionee2e_base_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    )
                                )
                            ),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        task_name="SANDBOX_CI_FIJI_EXPERIMENTS_RELEASE_RUNNER",
                        search_subtype="images",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="web",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="hermionee2e_base_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    )
                                )
                            ),
                        ),
                        ctx={
                            "tools": ["hermione-e2e", "hermione"],
                            "service": "images",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        task_name="SANDBOX_CI_FIJI_EXPERIMENTS_RELEASE_RUNNER",
                        search_subtype="video",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="web",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="hermionee2e_base_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    )
                                )
                            )
                        ),
                        ctx={
                            "tools": ["hermione-e2e", "hermione"],
                            "platforms": ["desktop", "touch-pad", "touch-phone", "tv"],
                            "service": "video",
                        },
                    )
                )
                for t in SearchIntergationTestBundle.get_bundle("web", "report_web_priemka"):
                    branch_part.append(t)

                arcadia_tests = [
                    (
                        [
                            "web/daemons/flags_raw_provider/tests/shoot_tests",
                            "web/daemons/flags_raw_provider/tests/ut",
                            "web/library/condition_evaluation/ut",
                            "web/library/flags_merge/ut",
                        ],
                        ["address", "thread", "memory", "leak", "undefined"]
                    ),
                ]
                for targets, sanitizers in arcadia_tests:
                    for sanitize in sanitizers:
                        branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                            task_name="KOSHER_YA_MAKE",
                            job_params={
                                "job_name_parameter": "ARCADIA_TESTS_SANITIZE_" + sanitize.upper(),
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                                "apiargs": {
                                    "kill_timeout": 5 * 3600,
                                }
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key=sandbox_constants.ARCADIA_URL_KEY,
                                    transform=lambda x, params: "{}/arcadia@{}".format(x.svn_ssh_url, x.revision),
                                ),
                            ),
                            ctx={
                                "targets": ';'.join(targets),
                                "test": True,
                                "disable_test_timeout": True,
                                "sanitize": sanitize,
                            },
                        ))

                umbrella_parents = [
                    jg_job_triggers.JobTriggerMetaTest(
                        job_name_parameter="SEARCH_INTEGRATION_TEST",
                    ),
                    jg_job_triggers.JobTriggerMetaTest(
                        job_name_parameter="SEARCH_INTEGRATION_TEST_SOY_HTTP",
                    ),
                    jg_job_triggers.JobTriggerMetaTest(
                        job_name_parameter="SEARCH_INTEGRATION_TEST_STYLE",
                    ),
                    jg_job_triggers.JobTriggerTestTdiAndRearr(),
                ]
                for vertical in ["web", "images", "video"]:
                    umbrella_parents.append(
                        jg_job_triggers.JobTriggerLaunchMetrics(
                            job_name_parameter=vertical,
                        )
                    )
                    umbrella_parents.append(
                        jg_job_triggers.JobTriggerE2ETest(
                            job_name_parameter=vertical,
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=umbrella_parents,
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "flags_provider_binary_res_id",
                                        "FLAGS_PROVIDER_BINARY_BUNDLE_RESOURSE_TYPE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "flags_provider_config_res_id",
                                        "FLAGS_PROVIDER_CONFIG_RESOURSE_TYPE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "flags_provider_instancectl_res_id",
                                        "FLAGS_PROVIDER_INSTANCE_CTL_RESOURSE_TYPE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "shared_flags_provider_binary_res_id",
                                        "FLAGS_PROVIDER_BINARY_BUNDLE_SHARED",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "shared_flags_provider_config_res_id",
                                        "FLAGS_PROVIDER_CONFIG_SHARED",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "shared_flags_provider_instancectl_res_id",
                                        "FLAGS_PROVIDER_INSTANCE_CTL_SHARED",
                                    ),
                                ),
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="flags_provider",
                resource_type="FLAGS_PROVIDER_BINARY_BUNDLE_RESOURSE_TYPE",
                resource_name="flags_provider_binary_res_id",
                build_ctx_key="arcadia_url",
                deploy=SERVICES['web'],
            ),
            configs.ReleasedResourceInfo(
                name="config.json",
                resource_type="FLAGS_PROVIDER_CONFIG_RESOURSE_TYPE",
                resource_name="flags_provider_config_res_id",
                build_ctx_key="arcadia_url",
            ),
            configs.ReleasedResourceInfo(
                name="flags_provider_instancectl_res_id",
                resource_type="FLAGS_PROVIDER_INSTANCE_CTL_RESOURSE_TYPE",
            ),
            configs.ReleasedResourceInfo(
                name="flags_provider",
                resource_type="FLAGS_PROVIDER_BINARY_BUNDLE_SHARED",
                resource_name="shared_flags_provider_binary_res_id",
                build_ctx_key="arcadia_url",
                deploy=SERVICES['shared'],
            ),
            configs.ReleasedResourceInfo(
                name="config.json",
                resource_type="FLAGS_PROVIDER_CONFIG_SHARED",
                resource_name="shared_flags_provider_config_res_id",
                build_ctx_key="arcadia_url",
            ),
            configs.ReleasedResourceInfo(
                name="shared_flags_provider_instancectl_res_id",
                resource_type="FLAGS_PROVIDER_INSTANCE_CTL_SHARED",
            ),
        ]
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "alex-ersh",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["alex_ersh"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "alex-ersh"
            queue = "SEAREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка flags_provider {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "alex-ersh",
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "users/alex-ersh/releases/"
        observed_paths = [
            "arcadia/web/daemons/flags_raw_provider",
            "arcadia/web/library/condition_evaluation",
            "arcadia/web/library/flags_merge",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="flags-provider",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="flags-provider",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="FLAGS_PROVIDER_CORE_BUNDLE.tar.gz",
                                param_name="flags_provider_binary_res_id",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="config.json", param_name="flags_provider_config_res_id"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="instancectl.conf", param_name="flags_provider_instancectl_res_id"
                            ),
                        ],
                        parent_service="hamster_flags_provider_vla_web_yp",
                    ),
                ],
            ),
            "shared": yappy_cfg.YappyTemplateCfg(
                template_name="flags-provider-shared",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="flags-provider-shared",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="FLAGS_PROVIDER_CORE_BUNDLE.tar.gz",
                                param_name="shared_flags_provider_binary_res_id",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="config.json", param_name="shared_flags_provider_config_res_id"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="instancectl.conf", param_name="shared_flags_provider_instancectl_res_id"
                            ),
                        ],
                        parent_service="hamster_flags_provider_vla_shared",
                    ),
                ],
            )
        }
