# -*- coding: utf-8 -*-

import os
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.configs.flags_provider import FlagsProviderTestsBundle


WEB_SERVICES = [
    "prestable_flags_provider_sas_web_yp",
    "production_flags_provider_sas_web_yp",
    "production_flags_provider_man_web_yp",
    "production_flags_provider_vla_web_yp",
    "hamster_flags_provider_sas_web_yp",
    "hamster_flags_provider_man_web_yp",
]

SHARED_SERVICES = [
    "production_flags_provider_sas_shared",
    "production_flags_provider_man_shared",
    "production_flags_provider_vla_shared",
    "hamster_flags_provider_sas_shared",
    "hamster_flags_provider_man_shared",
    "hamster_flags_provider_vla_shared",
]

SANITIZERS_TESTS = {
    "targets": [
        "web/daemons/flags_raw_provider/tests/shoot_tests",
        "web/daemons/flags_raw_provider/tests/ut",
        "web/library/condition_evaluation/ut",
        "web/library/flags_merge/ut",
    ],
    "sanitizers": ["address", "thread", "memory", "leak", "undefined"],
}

PARENT_SERVICE = "hamster_flags_provider_vla_web_yp"

EXECUTABLE_PATH = "web/daemons/flags_raw_provider"


class FlagsProviderCICfg(configs.ReferenceCIConfig):
    name = "flags_provider_ci"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="upper"),
        login="alex-ersh"
    )

    # metrics launch
    component_group = "reference_component_metricsed"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = EXECUTABLE_PATH
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "REPORT_CORE"

        ya_make_abs_paths_glob = [
            os.path.join(EXECUTABLE_PATH, "**"),
        ]

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        # JG params and stages init
        add_beta_generator = "web"

        # configuring auto-deploy
        release_manually = False

        build_task = "projects/upper_search/flags_provider/build_task"

        @jg_flow.release_flow(
            stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES,
        )
        def release(self):
            graph = super(self.__class__, self).release(self)

            main_stage_entry_cube = graph.get("main_graph_entry")
            beta_cube_web = graph.get("generate_beta__flags_provider_ci__web")
            release_entry_cube = graph.get("release_stage_entry")

            #  tests init
            tests = FlagsProviderTestsBundle.get_bundle(
                targets=SANITIZERS_TESTS["targets"],
                sanitizers=SANITIZERS_TESTS["sanitizers"],
                entry_cube=main_stage_entry_cube,
                beta_cube=beta_cube_web,
                soy_pool="report_web_priemka",
            )

            # add cubes to graph
            for test in tests:
                release_entry_cube.add_requirement(test)
                graph.add(test)

            return graph

        def _check_releasable_item_is_suitable(self, ri):
            return hasattr(ri.data, "resource_type") and ri.data.resource_type != "SCHEDULED_RM_RELEASE_DATA"

        # activating build cube
        def _get_build_cube(self, graph):
            return jg_cube.Cube(
                name=self.build_cube_name,
                task=self.build_task,
                input=jg_cube.CubeInput(
                    arcadia_url=rm_const.CIJMESPathCommon.ARCADIA_URL_SVN,
                ),
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )

        # activate Morty release
        def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
            return [
                release_cubes.ScheduleRelease(
                    name="release_{}_{}_web".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    flows=["deploy"],
                    warden_component_name="flags_provider",
                    warden_parent_component_name="web",
                    deploy_system=deploy_system,
                    schedule_mode="create_and_schedule",
                    input=jg_cube.CubeInput(
                        component_resources={
                            ri.name: build.output.resources[ri.data.resource_type].first().id
                            for ri in releasable_items if "_shared" not in ri.name
                        },
                    ),
                    manual=self.release_manually,
                ),
                release_cubes.ScheduleRelease(
                    name="release_{}_{}_shared".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    flows=["deploy_shared"],
                    warden_component_name="flags_provider",
                    warden_parent_component_name="web",
                    deploy_system=deploy_system,
                    schedule_mode="create_and_schedule",
                    input=jg_cube.CubeInput(
                        component_resources={
                            ri.name: build.output.resources[ri.data.resource_type].first().id
                            for ri in releasable_items if "_shared" in ri.name
                        },
                    ),
                    manual=self.release_manually,
                ),
            ]

    class Releases(configs.ReferenceCIConfig.Releases):
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "alex-ersh",
        ]

        @property
        def releasable_items(self):
            web_deploy = [
                ri.NannyDeployInfo([
                    ri.DeployService(service) for service in WEB_SERVICES
                ]),
            ]

            shared_deploy = [
                ri.NannyDeployInfo([
                    ri.DeployService(service) for service in SHARED_SERVICES
                ]),
            ]

            return [
                ri.ReleasableItem(
                    name="flags_provider",
                    data=ri.SandboxResourceData("FLAGS_PROVIDER_BINARY_BUNDLE_RESOURSE_TYPE", dst_path="flags_provider"),
                    deploy_infos=web_deploy,
                ),
                ri.ReleasableItem(
                    name="config",
                    data=ri.SandboxResourceData("FLAGS_PROVIDER_CONFIG_RESOURSE_TYPE", dst_path="config.json"),
                    deploy_infos=web_deploy,
                ),
                ri.ReleasableItem(
                    name="instancectl",
                    data=ri.SandboxResourceData("FLAGS_PROVIDER_INSTANCE_CTL_RESOURSE_TYPE", dst_path="instancectl.conf"),
                    deploy_infos=web_deploy,
                ),
                ri.ReleasableItem(
                    name="flags_provider_shared",
                    data=ri.SandboxResourceData("FLAGS_PROVIDER_BINARY_BUNDLE_SHARED", dst_path="flags_provider"),
                    deploy_infos=shared_deploy,
                ),
                ri.ReleasableItem(
                    name="config_shared",
                    data=ri.SandboxResourceData("FLAGS_PROVIDER_CONFIG_SHARED", dst_path="config.json"),
                    deploy_infos=shared_deploy,
                ),
                ri.ReleasableItem(
                    name="instancectl_shared",
                    data=ri.SandboxResourceData("FLAGS_PROVIDER_INSTANCE_CTL_SHARED", dst_path="instancectl.conf"),
                    deploy_infos=shared_deploy,
                ),
                ri.DynamicReleasableItem(
                    name="scheduled_bundle",
                    data=ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    deploy_infos=[ri.NannyDeployInfo()],
                ),
            ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="flags-provider",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="flags-provider",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="FLAGS_PROVIDER_CORE_BUNDLE.tar.gz",
                                param_name="flags_provider",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="config.json",
                                param_name="config"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="instancectl.conf",
                                param_name="instancectl"
                            ),
                        ],
                        parent_service=PARENT_SERVICE,
                    ),
                ],
            ),
        }

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["alex_ersh"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "alex-ersh"
            queue = "SEAREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка flags_provider {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "alex-ersh",
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "users/alex-ersh/releases/"
        observed_paths = [
            "arcadia/web/daemons/flags_raw_provider",
            "arcadia/web/library/condition_evaluation",
            "arcadia/web/library/flags_merge",
        ]
