# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class FloydCfg(cfg.ReferenceBranchedConfig):
    name = "floyd"
    # https://abc-back.yandex-team.ru/api/v4/services/members/?service__slug=MED&role__in=16
    responsible = cfg.Responsible(abc=cfg.Abc(role_id=16, component_id=3790), login="denvr")

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "CHATS_FEEDBACK"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_PACKAGE",
                        job_params={
                            "apiargs": {
                                "kill_timeout": 10800,
                            },
                        },
                        out={"FLOYD_PACKAGE": 20},
                        ctx={
                            "package_type": "docker",
                            "docker_push_image": True,
                            "docker_registry": "registry.yandex.net",
                            "docker_image_repository": "webmaster",
                            "packages": "quality/functionality/chats/floyd/package.json",
                            "docker_user": "robot-chats-releases",
                            "docker_token_vault_name": "robot-chats-releases-doker-oauth-token",
                            "docker_build_network": "host",
                            "resource_type": "FLOYD_PACKAGE",
                            "checkout": False,
                            "ya_yt_store": True,
                            "ignore_recurses": False,
                        }
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.stable, rm_const.ReleaseStatus.testing]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "floyd_package_res_id",
                                            "FLOYD_PACKAGE",
                                        )
                                    )
                                )
                            ),
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                return release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(conditions=[], join_strategy="OR"),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="medchats_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="medchats_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="medchats_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="medchats_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(cfg.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["medchats_comp"]
            config = cfg.RmTelegramNotifyConfig(chats=chats)

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "denvr"
            queue = "FLOYDREL"
            dev_queue = "FLOYD"
            summary_template = u"FLOYD: Релиз {}"
            workflow = {
                "open": "accepting",
                "accepting": "qualityOK",
                "qualityOK": "deploying",
                "deploying": "production",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
            }
            followers = [
                "denvr",
                "woolly",
                "a-sadovnikov",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "chats/floyd/releases/"
        observed_paths = [
            "arcadia/quality/functionality/chats/floyd",
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="floyd_package_res_id",
                    data=ri.SandboxResourceData("FLOYD_PACKAGE"),
                ),
            ]
        release_followers_permanent = [
            "denvr",
        ]
