# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.core.const as rm_const

import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class FrontendVideoHostingCfg(configs.ReferenceBranchedConfig):
    name = "frontend_video_hosting"
    responsible = "i-sokolov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "vh-frontend"
        trunk_task_owner = "VH"
        branch_db_template = "vh-frontend-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=False,
                            seconds_from_last_run_commit=3600,
                            time_interval_list=[(4, 6)],
                            weekday_list=[2],
                            once_a_day=True,
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementBuildPackageBranched(
                        task_name="KOSHER_YA_PACKAGE",
                        job_params={
                            "job_name_parameter": "PACKAGE",
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 30 * 1024 ** 3,  # 30 Gb
                                },
                            },
                        },
                        resource_names="YABS_VH_FRONTEND_RELEASE",
                        package_names="yabs/vh/frontend/package/package.json",
                        ctx={
                            "create_debug_packages": True,
                            "do_not_remove_resources": False,
                            "ignore_fail_tests": False,
                            "run_long_tests": True,
                            "run_tests": True,
                            "save_build_output": True,
                            "strip_binaries": False,
                            "use_new_format": True,
                            "use_ya_dev": False,
                            "ya_yt_put": False,
                            "ya_yt_store": True,
                            "architecture_all": False,
                            "ya_yt_token_vault_name": "robot-yabs-vh_yt_token",
                            "ya_yt_token_vault_owner": "VH"
                        },
                        out={
                            "YABS_VH_FRONTEND_RELEASE": 100
                        },
                    ),
                    jg_build.JobGraphElementBuildPackageBranched(
                        task_name="KOSHER_YA_PACKAGE",
                        job_params={
                            "job_name_parameter": "PACKAGE_UGC",
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 30 * 1024 ** 3,  # 30 Gb
                                },
                            },
                        },
                        resource_names="VH_UGC_PUMPKIN_RELEASE",
                        package_names="extsearch/video/vh/ugc_pumpkin/package/package.json",
                        ctx={
                            "ya_yt_token_vault_name": "robot-yabs-vh_yt_token",
                            "ya_yt_token_vault_owner": "VH"
                        },
                        out={
                            "VH_UGC_PUMPKIN_RELEASE": 50
                        },
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="video-hosting",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "frontend_package_res_id",
                                        "YABS_VH_FRONTEND_RELEASE",
                                    )
                                ),
                                job_name_parameter="PACKAGE",
                            ),
                        ),
                    )
                ]
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="VH_FRONTEND_JSON_SCHEMA_VALIDATOR",
                        job_params={
                            "job_name_parameter": "VH_VALIDATION_TEST",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="video-hosting",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="host",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster.yandex.ru".format(x),
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "binary_executor_release_type": "stable"
                        },
                    ),
                )
                umbrella_arrows = [
                    jg_job_triggers.JobTriggerTestBranchCommon(
                        job_name_parameter="VH_VALIDATION_TEST",
                    )
                ]
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=umbrella_arrows,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.EVERY_N_COMMIT, 1000000),
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=umbrella_arrows,
                    )
                )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_branch_part = super(self.__class__, self)._release
                release_part = []
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_stage_job_params = None if release_stage == rm_const.ReleaseStatus.stable else {
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    }
                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        job_arrows=[
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="PACKAGE",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "frontend_package_res_id",
                                        "YABS_VH_FRONTEND_RELEASE"
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="PACKAGE_UGC",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "ugc_pumpkin_package_res_id",
                                        "VH_UGC_PUMPKIN_RELEASE",
                                    )
                                )
                            ),
                        ],
                    ))
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                        job_params=release_stage_job_params
                    ))
                return default_branch_part + release_part

            @property
            def _trunk_part(self):
                this_trunk_part = [
                    jg_build.JobGraphElementBuildPackageTrunk(
                        task_name="KOSHER_YA_PACKAGE",
                        job_params={
                            "job_name_parameter": "PACKAGE_TRUNK",
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 30 * 1024 ** 3,  # 30 Gb
                                },
                            },
                        },
                        resource_names="YABS_VH_FRONTEND_TRUNK",
                        package_names="yabs/vh/frontend/package/package.json",
                        ctx={
                            "create_debug_packages": True,
                            "do_not_remove_resources": False,
                            "ignore_fail_tests": False,
                            "run_long_tests": True,
                            "run_tests": True,
                            "save_build_output": True,
                            "strip_binaries": False,
                            "use_new_format": True,
                            "use_ya_dev": False,
                            "ya_yt_put": False,
                            "ya_yt_store": True,
                            "architecture_all": False,
                            "ya_yt_token_vault_name": "robot-yabs-vh_yt_token",
                            "ya_yt_token_vault_owner": "VH"
                        },
                        out={
                            "YABS_VH_FRONTEND_TRUNK": 100
                        },
                    ),
                    jg_release.JobGraphElementReleaseBase(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=rm_const.ReleaseStatus.testing,
                        release_item="PACKAGE_TRUNK",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 180),
                            "filter_targets": [
                                "yabs/vh/frontend",
                                "extsearch/video/vh"
                            ],
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny.name,
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=[
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="frontend_vh_package_testing",
                                        resource_name="YABS_VH_FRONTEND_TRUNK",
                                    ),
                                ],
                                job_name_parameter="PACKAGE_TRUNK",
                            )
                        ),
                    )
                ]
                return this_trunk_part + super(self.__class__, self)._trunk_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="frontend_package_res_id",
                    data=ri.SandboxResourceData("YABS_VH_FRONTEND_RELEASE"),
                    deploy_infos=[ri.NannyDeployInfo(ri.DeployService("vh_runtime_thurman", tags=["prod"]))]
                ),
                ri.ReleasableItem(
                    name="ugc_pumpkin_package_res_id",
                    data=ri.SandboxResourceData("VH_UGC_PUMPKIN_RELEASE"),
                ),
                ri.ReleasableItem(
                    name="frontend_vh_package_testing",
                    data=ri.SandboxResourceData("YABS_VH_FRONTEND_TRUNK")
                ),
            ]

        release_followers_permanent = [
            "fawnd2",
            "i-sokolov"
        ]
        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["frontend-vh"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "i-sokolov"
            queue = "VHFRONTRELEASES"
            dev_queue = "VHFRONTRELEASES"
            summary_template = u"Релиз фронтенда видеохостинга {}"
            components = u"Фронтенд Видеохостинга".encode("utf-8")
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "fawnd2",
                "i-sokolov"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            nanny_reports = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = None
        observed_paths = []
        review_groups = [
            "vh",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        _template_resources = [
            yappy_cfg.YappyParametrizedResource(
                local_path="package.tar.gz", param_name="frontend_package_res_id"
            )
        ]

        betas = {
            "video-hosting": yappy_cfg.YappyTemplateCfg(
                template_name="vh-runtime-thurman",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="vh-runtime-thurman",
                        resources=_template_resources,
                        parent_service="hamster_vh_runtime_thurman",
                        ignore_instance_spec=True,
                    ),
                ],
            ),
        }
