# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class GeminiCfg(configs.ReferenceBranchedConfig):
    name = "gemini"
    responsible = "alexromanov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "JUPITER"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                def update_ctx(default_ctx, additional_ctx):
                    default_ctx.update(additional_ctx)
                    return default_ctx

                build_jobs_params = [
                    (
                        "SEARCHPROXY_BINARY",
                        {
                            "targets": "robot/gemini/packages/searchproxy",
                            "arts": "robot/gemini/packages/searchproxy/searchproxy",
                            "result_rt": "GEMINI_SEARCHPROXY_BINARY",
                            "result_rd": "Gemini searchproxy binary",
                        }
                    ),
                    (
                        "GENERAL_CONFIG",
                        {
                            "targets": "robot/gemini/packages/gemini_config",
                            "arts": "robot/gemini/packages/gemini_config/gemini.cfg",
                            "result_rt": "GEMINI_GENERAL_CONFIG",
                            "result_rd": "Gemini general config",
                        },
                    ),
                    (
                        "QUOTER_CONFIG",
                        {
                            "targets": "robot/gemini/packages/quota_config",
                            "arts": "robot/gemini/packages/quota_config/squota.gemini.xml",
                            "result_rt": "GEMINI_QUOTER_CONFIG",
                            "result_rd": "Gemini quoter config",
                        },
                    ),
                    (
                        "SEARCHPROXY_CONFIG",
                        {
                            "targets": "robot/gemini/packages/proxy_config",
                            "arts": "robot/gemini/packages/proxy_config/searchproxy-gemini.conf",
                            "result_rt": "GEMINI_SEARCHPROXY_CONFIG",
                            "result_rd": "Gemini quoter config",
                        },
                    ),
                    (
                        "VIEWER_BINARY",
                        {
                            "targets": "robot/gemini/packages/viewer",
                            "arts": "robot/gemini/packages/viewer/viewer",
                            "result_rt": "GEMINI_VIEWER_BINARY",
                            "result_rd": "Gemini viewer binary",
                        },
                    ),
                ]
                for build_job_name_parameter, build_ctx in build_jobs_params:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="YA_MAKE_RELEASE_TO_NANNY",
                            job_params={
                                "apiargs": {
                                    "requirements": {
                                        "disk_space": 50 << 30,  # 50 Gb in bytes
                                    },
                                },
                                "job_name_parameter": build_job_name_parameter,
                            },
                            ctx=update_ctx(
                                {
                                    "arts_source": "",
                                    "result_single_file": True,
                                    sandbox_constants.DEFINITION_FLAGS_KEY: "-DDEBUGINFO_LINES_ONLY=yes",
                                    sandbox_constants.CHECKOUT_MODE: sandbox_constants.CHECKOUT_MODE_AUTO,
                                    sandbox_constants.CHECKOUT: True,
                                    sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                                    sandbox_constants.CLEAR_BUILD_KEY: False,
                                    sandbox_constants.CHECK_RETURN_CODE: True,
                                    sandbox_constants.TESTS_REQUESTED: False,
                                    sandbox_constants.YA_YT_DIR: "//home/jupiter/yamake_cache",
                                    sandbox_constants.YA_YT_PROXY: "arnold.yt.yandex.net",
                                    sandbox_constants.YA_YT_PUT: True,
                                    sandbox_constants.YA_YT_STORE: True,
                                    sandbox_constants.YA_YT_TOKEN_VAULT_NAME: "jupiter_yt_token",
                                    sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: "JUPITER",
                                },
                                build_ctx,
                            ),
                            out={build_ctx["result_rt"]: 100},
                        )
                    )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_job_arrows = []
                for release_item in ["searchproxy_binary", "general_config", "searchproxy_config", "quoter_config"]:
                    release_job_arrows.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter=release_item,
                            parent_job_data=(
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "gemini_{}".format(release_item),
                                    "GEMINI_{}".format(release_item.upper()),
                                ),
                            )
                        )
                    )
                release_job_arrows.append(
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="VIEWER_BINARY",
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=release_job_arrows,
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):

            @property
            def change_frequency(self):
                return {}

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="gemini_searchproxy_binary",
                    data=ri.SandboxResourceData("GEMINI_SEARCHPROXY_BINARY"),
                    deploy_infos=[ri.NannyDeployInfo(
                        [ri.DeployService("{}_gemini_searchproxy".format(i)) for i in rm_const.MAIN_LOCATIONS]
                    )]
                ),
                ri.ReleasableItem(
                    name="gemini_searchproxy_config",
                    data=ri.SandboxResourceData("GEMINI_SEARCHPROXY_CONFIG"),
                ),
                ri.ReleasableItem(
                    name="gemini_quoter_config",
                    data=ri.SandboxResourceData("GEMINI_QUOTER_CONFIG"),
                ),
                ri.ReleasableItem(
                    name="gemini_general_config",
                    data=ri.SandboxResourceData("GEMINI_GENERAL_CONFIG"),
                ),
            ]

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = [
                "search-components-releases@yandex-team.ru",
                "gemini-alerts@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["gemini_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "bvshuryg"
            queue = "GEMINIRELEASE"
            dev_queue = "GEMINI"
            summary_template = u"Gemini {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = []
            add_commiters_as_followers = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "robot/gemini/changelogs/"
        observed_paths = [
            "arcadia/robot/gemini",
        ]
        review_groups = [
            "gemini",
        ]
