import json


MEGAMIND_URL_TPL = (
    'http://vins.hamster.alice.yandex.net/speechkit/app/pa/?'
    'srcrwr=BASS_GeoCoderText2RoadName:{url}&'
    'srcrwr=BASS_GeoMetaSearchOrganization:{url}&'
    'srcrwr=BASS_GeoMetaSearchResolveText:{url}&'
    'srcrwr=BASS_GeoMetaSearchResolveTextNextPage:{url}&'
    'srcrwr=BASS_GeoMetaSearchReverseResolve:{url}&'
    'srcrwr=BASS_GeoMetaSearchRoutePointContext:{url}'
)


def make_beta_cgi(json_sources, host=None):
    try:
        beta_sources = json.loads(json_sources)
        experimental_sources = ["&search_experimental_source=%s" % source for source in beta_sources]
        if host:
            experimental_sources.append(
                "&host_config[inthosts][search]=http://addrs-testing.search.yandex.net/search/{}/".format(host)
            )
        experimental_sources_string = "".join(experimental_sources)
        return experimental_sources_string
    except Exception:
        return None


def make_beta_url(betas_sources):
    url_tpl = "http://addrs-testing.search.yandex.net/search/stable/yandsearch?{experimental_sources}"
    try:
        experimental_sources = []
        for beta_sources in betas_sources:
            experimental_sources.append(make_beta_cgi(beta_sources))
        experimental_sources_string = "".join(experimental_sources)
        experimental_sources_string = experimental_sources_string.replace("search_experimental_", "")
        return url_tpl.format(experimental_sources=experimental_sources_string)
    except Exception:
        return "failed to make_beta_url"


def make_megamind_url(beta_sources):
    try:
        geosearch_url = make_beta_url(beta_sources)
        return MEGAMIND_URL_TPL.format(url=geosearch_url)
    except Exception:
        return "failed to make_megamind_url"


def make_megamind_url_for_metasearch(upper, middle):
    metasearch_url = 'http://addrs-testing.search.yandex.net/search/{}/yandsearch?experimental_source={}'.format(upper, middle)
    try:
        return MEGAMIND_URL_TPL.format(url=metasearch_url)
    except Exception:
        return "failed to make_megamind_url"
