# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.geo import _common as geo_utils
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class GeoBasesearchFormulaCfg(configs.ReferenceBranchedConfig):
    component_group = "geo_common"
    name = "addrs_base_formula"
    responsible = "evelkin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "geobasesearch-formula-trunk"
        trunk_task_owner = "GEOMETA-SEARCH"
        branch_db_template = "geobasesearch-formula-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 90 * (1024 ** 3),  # 90 Gb
                                },
                            },
                        },
                        ctx={
                            "targets": "extsearch/geo/base/formula/dynamic_mxnet_formulas",
                            "arts": "extsearch/geo/base/formula/dynamic_mxnet_formulas",
                            "build_system": "ya",
                            "build_type": "release",
                            "result_rd": "Geosearch dynamic formula",
                            "result_rt": "GEOSEARCH_DYNAMIC_FORMULA",
                        },
                        out={"GEOSEARCH_DYNAMIC_FORMULA": 40},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GET_ADDRS_REQUESTS",
                        job_params={
                            "job_name_parameter": "GET_REQUESTS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(),
                        ),
                        ctx={
                            "location": "MAN",
                            "number_of_hosts": 1,
                            "service": "Business",
                            "time_interval": 5,
                        },
                        out={"PLAIN_TEXT_QUERIES": 40},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GENERATE_PLAN_FROM_QUERIES",
                        job_params={
                            "job_name_parameter": "BUILD_SHOOTING_PLAN",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="GET_REQUESTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="queries_resource_id",
                                        resource_name="PLAIN_TEXT_QUERIES",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "minimal_plan_size": 1000000,
                            "resource_attrs": "type=addrs_business",
                        },
                        out={"BASESEARCH_PLAN": 40},
                    )
                )
                for beta_type, transform_params, transform_res in [
                    ("ref", lambda x, rm_config: "{rev}-ref".format(rev=x.revision), lambda build_res: []),
                    ("test", lambda x, rm_config: "{rev}-test".format(rev=x.revision), lambda build_res: [build_res]),
                ]:
                    branch_part.append(
                        jg_test.JobGraphElementYappyBetaGeneratorBranched(
                            beta_conf_type=beta_type,
                            job_params={
                                "task_name": "CREATE_ADDRS_BETA",
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key="branch",
                                    transform=jg_utils.get_major_release_number,
                                ),
                                jg_arrows.ParamsData(
                                    input_key="tag",
                                    transform=transform_params,
                                ),
                                jg_arrows.ParentsData(
                                    input_key="resources",
                                    triggers=(
                                        jg_job_triggers.JobTriggerBuild(
                                            parent_job_data=(
                                                jg_job_data.ParentDataResource(
                                                    input_key="build_res",
                                                    resource_name="GEOSEARCH_DYNAMIC_FORMULA",
                                                )
                                            )
                                        ),
                                    ),
                                    transform=transform_res,
                                ),
                            ),
                            ctx={
                                "beta_type_choices": "base",
                                "wait_time": 90,
                                "launch_type_choices": "RM",
                            },
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="test",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_extra_params",
                                        output_key="experimental_sources",
                                        transform=lambda x, params: geo_utils.make_beta_cgi(x, "stable"), ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="ref",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="sample_extra_params",
                                        output_key="experimental_sources",
                                        transform=lambda x, params: geo_utils.make_beta_cgi(x, "stable"),
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "metrics_mode_type": "release_machine",
                            "custom_template_name": "common.json",
                            "launch_template_quota": "geosearch",
                            "search_subtype": "geo",
                            "sample_beta": "reference",
                            "checked_beta": "test",
                            "enable_autoclicker": True,
                            "autoclicker_metric_name": "diff-2-serps-query-10",
                            "autoclicker_retry_count": 3,
                            "scraper_over_yt_pool": "geo",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="ADDRS_MAPKIT_COMPARE_TEST",
                        job_params={
                            "job_name_parameter": "LAUNCH_MAPKIT_ACCEPTANCE_YAPPY",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "behave_framevork_url": "arcadia:/arc/trunk/arcadia/search/geo/tools/geosearch_acceptance",
                            "launch_type_choices": "RM",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="ref",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="reference_stand_url",
                                        output_key="experimental_sources",
                                        transform=lambda x, params: geo_utils.make_beta_url([x]),
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="test",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="test_stand_url",
                                        output_key="experimental_sources",
                                        transform=lambda x, params: geo_utils.make_beta_url([x]),
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="LAUNCH_MAPKIT_ACCEPTANCE_YAPPY",
                            )
                        )
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "geobasesearch_formula_res_id",
                                        "GEOSEARCH_DYNAMIC_FORMULA",
                                    ),
                                ),
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                uppercase_name = self.name.upper()
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_BUILD_{}_SHOOTING_PLAN".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_PROFILE_GEOBASESEARCH": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_GEOBASESEARCH_FORMULA": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_CREATE_GEOBASESEARCH_BETA_ref": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_CREATE_GEOBASESEARCH_BETA_test": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_GET_{}_REQUESTS".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_LAUNCH_MAPKIT_ACCEPTANCE_{}_YAPPY".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_LAUNCH_METRICS_{}_YAPPY".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_LAUNCH_PERFORMANCE_TEST_{}_YAPPY".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="addrs_base_formula",
                resource_type="GEOSEARCH_DYNAMIC_FORMULA",
                resource_name="geobasesearch_formula_res_id",
                deploy=[(rm_const.ReleaseStatus.stable, "addrs_base_18")],
            ),
        ]
        release_followers_permanent = [
            "evelkin",
            "karas-pv",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["geobasesearch_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "robot-geosearch"
            queue = "GEOACCEPT"
            dev_queue = "SEARCH"
            summary_template = u"Приёмка формулы базового геопоиска {}"
            workflow = {}
            followers = [
                "evelkin",
                "karas-pv",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/GeoPoisk/log/GeobasesearchFormulaChangelog/"
        wiki_page_owner = "robot-geosearch"
        dirs = [
            "arcadia/extsearch/geo/base/formula/dynamic_mxnet_formulas",
        ]
        review_groups = [
            "geosearch",
        ]

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        """Metrics configuration"""
        limit_s = None

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "map-dev/basesearch-formula"
        branch_prefix = "pre-stable"
        tag_name = "geosearch/base-formula"
        tag_prefix = "stable"
        tag_folder_template = "{tag_prefix}-{branch_num}/r{tag_num}"
