# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers

from sandbox.projects.release_machine.components.configs.geo import _common as geo_utils


class GeoMetasearchCfg(configs.ReferenceBranchedConfig):
    component_group = "geo_common"
    name = "addrs_meta"
    responsible = "evelkin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "geometasearch-trunk"
        trunk_task_owner = "GEOMETA-SEARCH"
        branch_db_template = "geometasearch-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_GEOSEARCH",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 80 * (1024 ** 3),  # 80 Gb
                                },
                                "kill_timeout": 18000,
                            },
                        },
                        ctx={
                            "build_geometasearch": True,
                            "build_evlogdump": True,
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.BUILD_TYPE_KEY: sandbox_constants.RELEASE_BUILD_TYPE,
                        },
                        out={"GEOMETASEARCH_EXECUTABLE": 40},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="ADDRS_COLLECT_RMDATA",
                        job_params={
                            "job_name_parameter": "COLLECT_AUX_RESOURCES",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="branch",
                                transform=jg_utils.get_major_release_number,
                            ),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GET_ADDRS_REQUESTS",
                        job_params={
                            "job_name_parameter": "GET_REQUESTS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(),
                        ),
                        ctx={
                            "location": "VLA",
                            "number_of_hosts": 1,
                            "service": "Geo",
                            "time_interval": 300,
                            "number_of_requests": 10000,
                            "sample_origins_uniformly": True,
                        },
                        out={"PLAIN_TEXT_QUERIES": 40},
                    )
                )
                for beta_type, transform_params, transform_res in [
                    ("ref", lambda x, rm_config: "{rev}-ref".format(rev=x.revision), lambda build_res: []),
                    ("test", lambda x, rm_config: "{rev}-test".format(rev=x.revision), lambda build_res: [build_res]),
                ]:
                    branch_part.append(
                        jg_test.JobGraphElementYappyBetaGeneratorBranched(
                            beta_conf_type=beta_type,
                            job_params={
                                "task_name": "CREATE_ADDRS_BETA",
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key="branch",
                                    transform=jg_utils.get_major_release_number,
                                ),
                                jg_arrows.ParamsData(
                                    input_key="tag",
                                    transform=transform_params,
                                ),
                                jg_arrows.ParentsData(
                                    input_key="resources",
                                    triggers=(
                                        jg_job_triggers.JobTriggerBuild(
                                            parent_job_data=(
                                                jg_job_data.ParentDataResource(
                                                    input_key="build_res",
                                                    resource_name="GEOMETASEARCH_EXECUTABLE",
                                                )
                                            )
                                        ),
                                    ),
                                    transform=transform_res,
                                ),
                            ),
                            ctx={
                                "beta_type_choices": "geometasearch",
                                "wait_time": 90,
                                "launch_type_choices": "RM",
                            },
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="COMPARE_GEOMETASEARCH_BINARIES",
                        job_params={
                            "job_name_parameter": "COMPARE_BINARIES",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="middlesearch_2_executable_resource_id",
                                        resource_name="GEOMETASEARCH_EXECUTABLE",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="GET_REQUESTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="middlesearch_request_1_resource_id",
                                        resource_name="PLAIN_TEXT_QUERIES",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="middlesearch_request_2_resource_id",
                                        resource_name="PLAIN_TEXT_QUERIES",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="COLLECT_AUX_RESOURCES",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="middlesearch_1_executable_resource_id",
                                        output_key="middlesearch_executable_resource_id",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="middlesearch_1_config_resource_id",
                                        output_key="middlesearch_config_resource_id",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="middlesearch_1_data_resource_id",
                                        output_key="middlesearch_data_resource_id",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="middlesearch_2_config_resource_id",
                                        output_key="middlesearch_config_resource_id",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="middlesearch_2_data_resource_id",
                                        output_key="middlesearch_data_resource_id",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                        ),
                        ctx={
                            "calc_mode": "middle",
                        },
                        out={"TASK_LOGS": 7},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="ADDRS_MAPKIT_COMPARE_TEST",
                        job_params={
                            "job_name_parameter": "LAUNCH_MAPKIT_ACCEPTANCE_YAPPY",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "behave_framevork_url": "arcadia:/arc/trunk/arcadia/search/geo/tools/geosearch_acceptance",
                            "launch_type_choices": "RM",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="ref",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="reference_stand_url",
                                        output_key="chaining_dict",
                                        transform=lambda x, params: "http://addrs-testing.search.yandex.net/search/{}/yandsearch?experimental_source={}".format(
                                            x.get('service').get('geometasearch_upper'),
                                            x.get('experimental_sources').get('geometasearch_middle')[0]
                                        ),
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="test",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="test_stand_url",
                                        output_key="chaining_dict",
                                        transform=lambda x, params: "http://addrs-testing.search.yandex.net/search/{}/yandsearch?experimental_source={}".format(
                                            x.get('service').get('geometasearch_upper'),
                                            x.get('experimental_sources').get('geometasearch_middle')[0]
                                        ),
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                        job_params={
                            "job_name_parameter": "LAUNCH_ALICE_INTEGRATION_TESTS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "uniproxy_url": "wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws",
                            "enable_stats": True,
                            "test_filters": "poi",
                            "launch_type": "geo",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="COLLECT_AUX_RESOURCES",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="release_ticket",
                                        output_key="startek_tiket",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParentsData(
                                input_key='tag_number',
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key='tag_name',
                                                output_key='tag_name',
                                            ),
                                        ),
                                    ),
                                ),
                                transform=lambda tag_name: "{}".format(tag_name),
                            ),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="test",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="megamind_url",
                                        output_key="chaining_dict",
                                        transform=lambda x, params: geo_utils.make_megamind_url_for_metasearch(
                                            x.get('service').get('geometasearch_upper'),
                                            '{}:80'.format(x.get('instances').get('geometasearch_middle')[0])
                                        ),
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        search_subtype="geo",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="ref",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="sample_beta",
                                        output_key="beta_service",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="sample_extra_params",
                                        output_key="chaining_dict",
                                        transform=lambda x, params: "&host_config[inthosts][search]=http://addrs-testing.search.yandex.net/search/{}/&search_experimental_source={}".format(
                                            x.get('service').get('geometasearch_upper'),
                                            x.get('experimental_sources').get('geometasearch_middle')[0]
                                        ),
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="test",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_service",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_extra_params",
                                        output_key="chaining_dict",
                                        transform=lambda x, params: "&host_config[inthosts][search]=http://addrs-testing.search.yandex.net/search/{}/&search_experimental_source={}".format(
                                            x.get('service').get('geometasearch_upper'),
                                            x.get('experimental_sources').get('geometasearch_middle')[0]
                                        ),
                                    ),
                                ),
                            )
                        ),
                        ctx={
                            "metrics_mode_type": "release_machine",
                            "custom_template_name": "common.json",
                            "template_source": "arcadia",  # METRICSSUPPORT-4702
                            "launch_template_quota": "geosearch",
                            "enable_autoclicker": True,
                            "autoclicker_metric_name": "diff-2-serps-query-10",
                            "autoclicker_retry_count": 3,
                            "scraper_over_yt_pool": "geo",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        task_name="SANDBOX_CI_WEB4_EXPERIMENTS_RELEASE_RUNNER",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="test",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="hermionee2e_base_url",
                                        output_key="hamster_url",
                                    ),
                                ),
                            )
                        ),
                        ctx={
                            "task_retries_delay": ["2", "4"],
                            "task_retries": 2,
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="COMPARE_BINARIES",
                            ),
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="geo",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="LAUNCH_MAPKIT_ACCEPTANCE_YAPPY",
                            ),
                        ),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "geometasearch_binary_res_id",
                                        "GEOMETASEARCH_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_params={
                            "filter_targets": [
                                "extsearch/geo/meta/daemon",
                            ],
                            "ignored_paths": [
                                "arcadia/ads",
                                "arcadia/adv",
                                "arcadia/apphost",
                                "arcadia/balancer",
                                "arcadia/build",
                                "arcadia/catboost",
                                "arcadia/certs",
                                "arcadia/contrib",
                                "arcadia/crypta",
                                "arcadia/dict",
                                "arcadia/dj",
                                "arcadia/entity",
                                "arcadia/geobase",
                                "arcadia/grut",
                                "arcadia/infra",
                                "arcadia/irt",
                                "arcadia/kernel",
                                "arcadia/library",
                                "arcadia/logbroker",
                                "arcadia/mapreduce",
                                "arcadia/maps",
                                "arcadia/market",
                                "arcadia/mlp",
                                "arcadia/modadvert",
                                "arcadia/quality",
                                "arcadia/robot",
                                "arcadia/rtmapreduce",
                                "arcadia/scarab",
                                "arcadia/search",
                                "arcadia/sprav",
                                "arcadia/statbox",
                                "arcadia/tools",
                                "arcadia/util",
                                "arcadia/web",
                                "arcadia/yabs",
                                "arcadia/ydb",
                                "arcadia/ysite",
                                "arcadia/yweb",
                                "arcadia/zora",
                            ]
                        },
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=True,
                            once_a_day=True,
                            time_interval_list=[(1, 1)],
                            weekday_list=[0, 1, 2, 3, 4],
                        ),
                    ),
                ]

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                uppercase_name = self.name.upper()
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_BUILD_RELEASE_GEOMETASEARCH": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_COMPARE_GEOMETASEARCH_BINARIES": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_CREATE_GEOMETASEARCH_BETA_ref": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_CREATE_GEOMETASEARCH_BETA_test": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_GET_{}_REQUESTS".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_HERMIONE_TEST".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_LAUNCH_MAPKIT_ACCEPTANCE_{}_YAPPY".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_LAUNCH_METRICS_{}_YAPPY".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="addrs_meta",
                resource_type="GEOMETASEARCH_EXECUTABLE",
                resource_name="geometasearch_binary_res_id",
                deploy=[(rm_const.ReleaseStatus.stable, "addrs_upper")],
            ),
        ]
        release_followers_permanent = [
            "evelkin",
            "karas-pv",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="AcceptanceTest",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBetaGeneration",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="geobasesearch_comp_q",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["geobasesearch_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "robot-geosearch"
            queue = "GEOACCEPT"
            dev_queue = "SEARCH"
            summary_template = u"Приёмка бинарникa геопоискового метапоиска {}"
            workflow = {}
            followers = [
                "evelkin",
                "karas-pv",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/GeoPoisk/log/GeometasearchChangelog/"
        wiki_page_owner = "robot-geosearch"
        dirs = [
            "arcadia/extsearch/geo/meta/daemon",
            "arcadia/extsearch/geo/meta/features",
            "arcadia/extsearch/geo/meta/lib",
            "arcadia/extsearch/geo/meta/rank",
            "arcadia/extsearch/geo/meta/rearrs/common",
            "arcadia/extsearch/geo/meta/rearrs/middle",
            "arcadia/extsearch/geo/meta/rearrs/upper",
            "arcadia/extsearch/geo/meta/report",
            "arcadia/extsearch/geo/meta/reqans",
            "arcadia/extsearch/geo/meta/search",
            "arcadia/extsearch/geo/meta/v2",
            "arcadia/extsearch/geo/kernel",
            "arcadia/extsearch/geo/base/formula",
            "arcadia/extsearch/geo/fast_export",
        ]
        review_groups = [
            "geosearch",
        ]

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        """Metrics configuration"""
        limit_s = None

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "geometa/metasearch"
        branch_prefix = "pre-stable"
        tag_name = "geosearch/meta"
        tag_prefix = "stable"
        tag_folder_template = "{tag_prefix}-{branch_num}/r{tag_num}"
