# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.geosuggest.tests import ACCEPTANCE_AUTOTEST_PARAMS
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows


class GeoSuggestCfg(configs.ReferenceBranchedConfig):
    component_group = "geo_common"
    name = "geosuggest"
    responsible = "vi002"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "GEO_SUGGEST"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_SEARCH",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 90 * (1024 ** 3),
                                },
                                "kill_timeout": 18000,
                            },
                        },
                        ctx={
                            "build_geosuggestd": True,
                            common_const.BUILD_SYSTEM_KEY: common_const.YMAKE_BUILD_SYSTEM,
                            common_const.BUILD_TYPE_KEY: "release",
                        },
                        out={"GEO_SUGGEST_WEBDAEMON": 40},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="ADDRS_COLLECT_RMDATA",
                        job_params={
                            "job_name_parameter": "COLLECT_AUX_RESOURCES_SUGGEST",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="CREATE_ADDRS_BETA",
                        job_params={
                            "job_name_parameter": "test",
                        },
                        ctx={
                            "beta_type_choices": "geosuggest",
                            "wait_time": 90,
                            "launch_type_choices": "RM",
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key="resources",
                                triggers=(
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataResource(
                                                input_key="build_res",
                                                resource_name="GEO_SUGGEST_WEBDAEMON",
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="COLLECT_AUX_RESOURCES_SUGGEST",
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="collect_res",
                                                output_key="data_from_prod",
                                            )
                                        ),
                                    ),
                                ),
                                transform=lambda build_res, collect_res: [collect_res, build_res],
                            ),
                            jg_arrows.ParamsData("branch", jg_utils.get_major_release_number),
                            jg_arrows.ParamsData("tag", lambda x, rm_config: "{rev}-test".format(rev=x.revision)),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="CREATE_ADDRS_BETA",
                        job_params={
                            "job_name_parameter": "ref",
                        },
                        ctx={
                            "beta_type_choices": "geosuggest",
                            "wait_time": 90,
                            "launch_type_choices": "RM",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(),
                            jg_arrows.ParentsData(
                                input_key="resources",
                                triggers=(
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="COLLECT_AUX_RESOURCES_SUGGEST",
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="collect_res",
                                                output_key="data_from_prod",
                                            )
                                        ),
                                    ),
                                ),
                                transform=lambda collect_res: [collect_res],
                            ),
                            jg_arrows.ParamsData("branch", jg_utils.get_major_release_number),
                            jg_arrows.ParamsData("tag", lambda x, rm_config: "{rev}-ref".format(rev=x.revision)),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GEO_SUGGEST_COLLECT_REQUESTS",
                        job_params={
                            "job_name_parameter": "GET_REQUESTS",
                        },
                        ctx={
                            "count": 100000,
                            "min_response_time": 0,
                            "binary_executor_release_type": "stable",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(),
                        ),
                        out={"GEO_SUGGEST_WEBDAEMON_PLAN": 40},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GEO_SUGGEST_ACCEPTANCE",
                        job_params={
                            "job_name_parameter": "ACCEPTANCE",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "apiargs": {
                                "kill_timeout": 5 * 3600,
                            },
                        },
                        ctx={
                            "geosuggest_autotest_arguments": ' '.join(ACCEPTANCE_AUTOTEST_PARAMS),
                            "geosuggest_use_personal_mocks": True,
                            "geosuggest_deploy_to_nanny_in_case_of_passed_tests": False,
                            "geosuggest_emails_anyway": False,
                            "geosuggest_emails_to": "geo-suggest@yandex-team.ru",
                            "geosuggest_external_daemon_url": "http://suggest-maps.yandex.{domain}/suggest-geo",
                            "geosuggest_path_to_autotest": "autotest",
                            "geosuggest_release_on_autodeploy": "stable",
                            "geosuggest_run_performance_tests": True,
                            "geosuggest_sandbox_vault_nanny_token_name": "nanny_token",
                            "geosuggest_sandbox_vault_owner": "GEO_SUGGEST",
                            "geosuggest_stable_result_parameter": "production_snapshot",
                            "geosuggest_start_timeout": 7200,
                            "geosuggest_shutdown_timeout": 120,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="geosuggestd_resource_id",
                                        resource_name="GEO_SUGGEST_WEBDAEMON",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="GET_REQUESTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="geosuggest_dolbilka_plan_resource_id",
                                        resource_name="GEO_SUGGEST_WEBDAEMON_PLAN",
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="COLLECT_AUX_RESOURCES_SUGGEST",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="data_builder",
                                        output_key="data_builder",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="geosuggest_data_resource_id",
                                        output_key="geosuggest_data_resource_id",
                                    ),
                                )
                            ),
                            jg_arrows.ParamsData("branch", jg_utils.get_major_release_number),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="ACCEPTANCE",
                            )
                        )
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "geosuggest_binary",
                                        "GEO_SUGGEST_WEBDAEMON",
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_BUILD_GEOSUGGEST": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_GEOSUGGEST_ACCEPTANCE": rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="geosuggest_binary",
                    data=ri.SandboxResourceData("GEO_SUGGEST_WEBDAEMON"),
                    deploy_infos=[ri.single_nanny_service("suggest_maps_yp")]
                ),
            ]
        release_followers_permanent = [
            "y-oriekhov",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["geobasesearch_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "robot-geosearch"
            queue = "GEOACCEPT"
            dev_queue = "SEARCH"
            summary_template = u"Приёмка бинарникa геосаджеста {}"
            followers = [
                "y-oriekhov",
            ]
            use_task_author_as_assignee = False
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "JandeksPoisk/GeoPoisk/log/GeoSuggestChangelog/"
        observed_paths = [
            "arcadia/geosuggest",
            "arcadia/quality/trailer/suggest/services/maps",
        ]
        review_groups = [
            "geosuggest"
        ]

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        limit_s = None

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "map-dev/suggest"
        branch_prefix = "pre-stable"
        tag_name = "suggest/geo"
        tag_folder_template = "{tag_prefix}-{branch_num}/r{tag_num}"
