# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.config_core.jg.cube.lib.metrics import SearchLaunchMetrics


class SearchLaunchMetricsGoods(SearchLaunchMetrics):
    LAUNCH_TEMPLATE_QUOTA = "products_production"

    @property
    def input_defaults(self):
        parent_defaults = super(SearchLaunchMetricsGoods, self).input_defaults
        parent_defaults.update({
            "template_source": "arcadia",
        })
        return parent_defaults


def add_metrics(graph, beta_cube_name='', scraper_over_yt_pool='products_production'):
    beta = graph.get(beta_cube_name)
    nanny = graph.get("release_stable_nanny")

    metrics = SearchLaunchMetricsGoods.by_generate_beta_cube(beta, scraper_over_yt_pool=scraper_over_yt_pool)
    graph.add(metrics)
    nanny.add_requirement(metrics)
