# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube


def add_shooting(graph, beta_cube_name='', component_name=''):
    startrek = graph.get("create_startrek_ticket")
    beta = graph.get(beta_cube_name)
    nanny = graph.get("release_stable_nanny")

    # TODO(lix0): лунопарку нужно знать dc чтобы выбрать танк
    shooting_config = """
        phantom:
            enabled: true
            package: yandextank.plugins.Phantom
            load_profile:
                load_type: rps
                schedule: const(10,3m)
            address: 'from_metaconf'
            ammofile: sandbox.AMMO_FILE
            ammo_attrs: 'ammo_label=goods_runtime_beta_acceptance_ammos'
        uploader:
            task: {task}
            operator: robot-goods
            job_name: shooting {component_name}
            job_dsc: 'started from sandbox'
        metaconf:
            enabled: true
            package: yandextank.plugins.MetaConf
            firestarter:
                target: {target}
                tank: sandbox
                dc: VLA
    """.format(component_name=component_name, task='{task}', target='{target}')

    prepare = jg_cube.Cube(
        name="prepare_shooting_config",
        task="projects/goods/format_text",
        input=jg_cube.CubeInput(
            config={
                "template": shooting_config,
                "kwargs": {
                    "task": startrek.output.st_ticket.key,
                    "target": jg_cube.CubeOutputTransformed(
                        [beta.output_params.new_beta_url],
                        lambda url_list: "{}.ru".format(url_list[0]),
                    ),  # use '.ru' betas
                }
            }
        ),
        needs=[beta]
    )
    shooting = jg_cube.Cube(
        name="shooting_beta",
        task="common/load/shooting",
        input=jg_cube.CubeInput(
            load={
                "config": prepare.output.result.text,
            },
            sandbox={
                "owner": "GOODS-RUNTIME",
                "token": "sandbox.token",
                "description": "Shooting {component_name}".format(component_name=component_name),
            },
        ),
        needs=[prepare]
    )
    assessment = jg_cube.Cube(
        name="shooting_assessment",
        task="common/load/assessment",
        input=jg_cube.CubeInput(
            shooting={
                "shooting_id": shooting.output.result.shooting_id,
            },
            conditions={
                "threshold": 3,
                "tests": [
                    "quantile50",
                    "quantile75",
                    "quantile85",
                    "quantile95",
                    "http_codes",
                    "net_codes",
                ],
                "reference": [
                    3003416,
                    3003419,
                ],
                    "ticket": startrek.output.st_ticket.key,
                    "st_token": "startrek.token",
                }
            ),
            needs=[shooting],
        )

    graph.add(prepare)
    graph.add(shooting)
    graph.add(assessment)

    nanny.add_requirement(assessment)
