# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import yappy as yappy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.configs.goods._goods_shooting as goods_shooting


class GoodsBackendsCfg(configs.ReferenceCIConfig):
    name = "goods_backend"
    display_name = "Goods Vertical Backends"
    # role_id=16 - Administration
    responsible = configs.Responsible(abc=configs.Abc(component_id=35213, role_id=16), login="starcev")

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        build_task = "YA_PACKAGE"
        add_beta_generator = ["web"]

        @flow.release_flow()
        def release(self):
            graph = super(self.__class__, self).release(self)

            release_prod = graph.get("release_stable_nanny")
            goods_shooting.add_shooting(graph, beta_cube_name='generate_beta__goods_backend__web', component_name='goods runtime')

            release_prod.input.update(wait_for_deploy=True)
            release_hamster = graph.get("release_testing_nanny")
            release_hamster.add_requirement(release_prod)
            release_hamster.manual = False
            release_hamster.title = "Release to Hamster"

            return graph

        @flow.precommit_check_flow()
        def goods_backend_pr_testing(self):

            resource_type = self.root_cfg.releases_cfg.releasable_items[0].data.resource_type
            package = self.root_cfg.releases_cfg.releasable_items[0].build_data.target

            dummy = dummy_cubes.Dummy(manual=True)

            build = build_cubes.OldYaPackage(
                packages=[package],
                resource_types=[resource_type],
                needs=[dummy],
            )

            gyb = yappy_cubes.GenerateYappyBeta(
                component_name=self.root_cfg.name,
                beta_conf_type="pr",
                input=jg_cube.CubeInput(
                    update_beta_mode="append",
                    beta_name_source="STRING",
                    patch_name="${context.target_revision.pull_request_id}",
                    component_resources={
                        "goods_apphost_backend_pkg": build.output.resources[resource_type].first().id,
                    },
                ),
            )

            return graph_base.Graph([dummy, build, gyb])

        @flow.register_flow()
        def goods_shooting_test_action(self):
            graph = graph_base.Graph([])
            main_graph_entry = dummy_cubes.Dummy("main_graph_entry")
            graph.add(main_graph_entry)

            build = self._get_build_cube(graph)
            resource_type = self.root_cfg.releases_cfg.releasable_items[0].data.resource_type

            gyb = yappy_cubes.GenerateYappyBeta(
                component_name=self.root_cfg.name,
                beta_conf_type="web",
                input=jg_cube.CubeInput(
                    update_beta_mode="append",
                    beta_name_source="STRING",
                    patch_name=rm_const.CIJMESPathCommon.TARGET_COMMIT_HASH,
                    component_resources={
                        "goods_apphost_backend_pkg": build.output.resources[resource_type].first().id,
                    },
                ),
                needs=[build],
            )

            shooting_config = """
                phantom:
                    enabled: true
                    package: yandextank.plugins.Phantom
                    load_profile:
                        load_type: rps
                        schedule: line(1,10,3m)
                    address: 'from_metaconf'
                    ammofile: sandbox.AMMO_FILE
                    ammo_attrs: 'ammo_label=goods_runtime_beta_acceptance_ammos'
                uploader:
                    task: {task}
                    operator: robot-goods
                    job_name: shooting goods runtime
                    job_dsc: 'started from sandbox'
                metaconf:
                    enabled: true
                    package: yandextank.plugins.MetaConf
                    firestarter:
                        target: {target}
                        tank: sandbox
                        dc: VLA
            """

            prepare = jg_cube.Cube(
                name="prepare_shooting_config",
                task="projects/goods/format_text",
                input=jg_cube.CubeInput(
                    config={
                        "template": shooting_config,
                        "kwargs": {
                            "task": "GOODS-2550",  # TODO(my34): доставать по аналогии с new_beta_url
                            "target": jg_cube.CubeOutputTransformed(
                                [gyb.output_params.new_beta_url],
                                lambda url_list: "{}.ru".format(url_list[0]),
                            ),  # use '.ru' betas
                        }
                    }
                ),
                needs=[gyb]
            )
            shooting = jg_cube.Cube(
                name="shooting_beta",
                task="common/load/shooting",
                input=jg_cube.CubeInput(
                    load={
                        "config": prepare.output.result.text,
                    },
                    sandbox={
                        "owner": "GOODS-RUNTIME",
                        "token": "sandbox.token",
                        "description": "Shooting Goods Runtime",
                    },
                ),
                needs=[prepare]
            )
            assessment = jg_cube.Cube(
                name="shooting_assessment",
                task="common/load/assessment",
                input=jg_cube.CubeInput(
                    shooting={
                        "shooting_id": shooting.output.result.shooting_id,
                    },
                    conditions={
                        "threshold": 3,
                        "tests": [
                            "http_codes",
                            "net_codes",
                        ],
                        "reference": [
                            3002519,
                        ],
                        "ticket": "GOODS-2550",  # TODO(my34): дотянуться до тикета
                        "st_token": "startrek.token",
                    }
                ),
                needs=[shooting],
            )

            graph.add(build)
            graph.add(gyb)
            graph.add(prepare)
            graph.add(shooting)
            graph.add(assessment)

            return graph

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/functionality/goods/runtime"
        secret = "sec-01fejk63r0pc9cqjfd7cv9h86c"
        sb_owner_group = "GOODS-RUNTIME"
        grant_config_update_permissions_to_release_machine_robot = False

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        use_arc = True
        arc_tag_folder = "tags/releases/goods-runtime"
        arc_branches_folder = "releases/goods-runtime"
        start_version = 13  # moved a.yaml after branch 12

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            queue = "GOODSREL"
            summary_template = "Goods backend Release #{}"
            use_task_author_as_assignee = False
            assignee = "starcev"

            # role_id=8 - Developer
            followers = configs.PeopleGroups(
                staff_groups=None,
                logins=None,
                abc_services=[configs.Abc(component_id=35213, role_id=8)],
            )
            add_commiters_as_followers = True
            ticket_type = "Release"
            tags = ["goods", "rm-main-ticket"]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["goods_devops"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/fFf1PB3VwUI2ZmIy"

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        observed_paths = ["arcadia/quality/functionality/goods/runtime"]
        wiki_page = ""

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="goods_apphost_backend_pkg",
                    data=ri.SandboxResourceData("GOODS_APPHOST_BACKENDS_PKG", ttl=30),
                    build_data=ri.BuildData(
                        target="quality/functionality/goods/runtime/infra/goods_backends_pkg.json",
                    ),
                    deploy_infos=[
                        ri.single_nanny_service("goods-runtime-production-vla"),
                        ri.single_nanny_service("goods-runtime-hamster-vla", stage=rm_const.ReleaseStatus.testing),
                    ],
                )
            ]

        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 10 * 60  # 10 min

    class Yappy(configs.ReferenceCIConfig.Yappy):

        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="goods-runtime-test",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="goods-runtime",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="goods-runtime-backend.tar.gz",
                                param_name="goods_apphost_backend_pkg",
                            ),
                        ],
                        parent_service="goods-runtime-hamster-vla",
                    ),
                ],
            ),
            "pr": yappy_cfg.YappyTemplateCfg(
                template_name="goods-runtime-test",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="goods-runtime",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="goods-runtime-backend.tar.gz",
                                param_name="goods_apphost_backend_pkg",
                            ),
                        ],
                        parent_service="goods-runtime-hamster-vla",
                    ),
                ],
            ),
        }
