# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core.jg import flow
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
import sandbox.projects.release_machine.components.configs.goods._goods_shooting as goods_shooting
import sandbox.projects.release_machine.components.configs.goods._goods_metrics as goods_metrics

from sandbox.projects.release_machine.core import releasable_items as ri

PATH_TO_BINARY = "arcadia/extsearch/goods/report/report_base"


class GoodsReportCfg(configs.ReferenceCIConfig):
    name = "goods_report"
    display_name = "Goods report"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="goods", component_id=35213, role_id=16),
        login="flyrise"
    )

    # metrics launch
    component_group = "reference_component_metricsed"

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "KOSHER_YA_MAKE"
        add_beta_generator = "goods"

        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.input.update(
                thinlto=True,
                definition_flags="-DCFLAGS=\"-mllvm -inline-threshold=1000 -fno-omit-frame-pointer\" -DLDFLAGS=\"-Wl,--thinlto-jobs=all\"",
                result_single_file=True,
            )
            return build

        @flow.release_flow(
            auto=dict(
                conditions=[
                    {
                        "since-last-release": "3d",
                    },
                    {
                        "since-last-release": "8h",
                        "min-commits": 100
                    }
                ]
            ),
        )
        def release(self):
            graph = super(self.__class__, self).release(self)

            goods_shooting.add_shooting(graph, beta_cube_name='generate_beta__goods_report__goods', component_name='goods report')
            goods_metrics.add_metrics(graph, beta_cube_name='generate_beta__goods_report__goods', scraper_over_yt_pool='products_production')

            return graph

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "extsearch/goods/report/report_base"
        secret = "sec-01fejk63r0pc9cqjfd7cv9h86c"
        sb_owner_group = "GOODS-RUNTIME"

        ya_make_abs_paths_glob = [
            "market/report/**",
            "extsearch/goods/report/**"
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        use_arc = True
        arc_tag_folder = "tags/releases/goods-runtime"
        arc_branches_folder = "releases/goods-runtime"
        start_version = 9  # a-yaml-dir

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="report",
                    build_data=ri.BuildData(
                        target="extsearch/goods/report/report_base",
                        artifact="extsearch/goods/report/report_base/report_bin",
                    ),
                    data=ri.SandboxResourceData("GOODS_REPORT_BINARY", ttl=30),
                    deploy_infos=[
                        ri.single_nanny_service("prep_report_goods_warehouse_sas"),
                        ri.single_nanny_service("prep_report_goods_warehouse_man"),
                        ri.single_nanny_service("prep_report_goods_warehouse_vla"),
                        ri.single_nanny_service("prod_report_goods_warehouse_sas"),
                        ri.single_nanny_service("prod_report_goods_warehouse_man"),
                        ri.single_nanny_service("prod_report_goods_warehouse_vla"),
                        ri.single_nanny_service("prep_report_goods_parallel_sas"),
                        ri.single_nanny_service("prep_report_goods_parallel_man"),
                        ri.single_nanny_service("prep_report_goods_parallel_vla"),
                        ri.single_nanny_service("prod_report_goods_parallel_sas"),
                        ri.single_nanny_service("prod_report_goods_parallel_man"),
                        ri.single_nanny_service("prod_report_goods_parallel_vla"),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 10 * 60  # 10 min

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        observed_paths = [
            "arcadia/market/report",
            "arcadia/extsearch/goods/report"
        ]
        use_dependency_dump = True
        wiki_page = ""

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            queue = "GOODSREL"
            summary_template = "Goods report Release #{}"
            use_task_author_as_assignee = False
            assignee = "flyrise"

            ticket_type = "Release"
            tags = ["goods", "rm-main-ticket"]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["goods_devops"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/fFf1PB3VwUI2ZmIy"

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "goods": yappy_cfg.YappyTemplateCfg(
                template_name="goods-report",
                working_betas_limit=2,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="goods-report",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="report",
                                param_name="report",
                            ),
                        ],
                        parent_service="goods_report_beta_template",
                        copy_coredump_policy=True,
                    ),
                ],
                new_yappy=True,
            ),
        }

    class MetricsCfg(configs.ReferenceCIConfig.MetricsCfg):
        limit_s = None
