# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


RESOURCES = [
    "HORIZON_AGENT_CONFIG_SHARED",
    "APP_HOST_STABLE_BRANCH_SHARED",
]


class GraphsSharedCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "graphs_shared"
    responsible = "dmitryno"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "REPORT_CORE"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_params={
                            "filter_targets": [
                                "apphost/conf/verticals/SHARED",
                            ],
                        },
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=False,
                            seconds_from_last_run_commit=3600,
                            seconds_from_last_run_start_time=3600,
                            time_interval_list=[(12, 13), (17, 18)],
                            weekday_list=[0, 1, 2, 3, 4, 5],
                        ),
                    ),
                ]

            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "SHARED",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="DEPLOY_NANNY_DASHBOARD",
                        job_params={
                            "job_name_parameter": "DEPLOY_RELEASE",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="deployment_task_id",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter=rm_const.ReleaseStatus.stable,
                            ),
                        ),
                        ctx={
                            'deployment_release_status': rm_const.ReleaseStatus.stable,
                            'deployment_nanny_dashboard_name': 'app_host_shared',
                            'deployment_nanny_dashboard_recipe': 'app_host_ppsa_auto',
                            'vault_name': 'nanny_oauth_token',
                            'vault_owner': 'APP_HOST',
                            'deployment_nanny_bool_wait': True,
                            'deployment_nanny_dashboard_filter': 'stable-app_host'
                        },
                    )
                )
                return release_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 1
        kpi_alert_skip_weekends = True

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[ri.single_nanny_service("production_app_host_vla_shared")],
                ) for resource in RESOURCES
            ]
        release_followers_permanent = [
            "dmitryno",
            "feldsherov",
        ]
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["report"]
            invite_link = "https://t.me/joinchat/CaUODkYSN2MyE5jE9xgJzg"
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "lebedev-aa"
            queue = "SEAREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка графов SHARED {}"
            components = u"graphs_shared"
            workflow = {}
            followers = []
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 4

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "apphost/graphs/shared/"
        observed_paths = [
            "arcadia/apphost/conf/verticals/SHARED",
            "arcadia/apphost/conf/backends",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/shared"
        tag_name = "apphost/conf/shared"
