# -*- coding: utf-8 -*-

from sandbox.projects.common.constants import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import const as rm_const

import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


NAME = "hollywood_general_conversation"
DISPLAY_NAME = "Hollywood (general_conversation)"

RESPONSIBLE = cfg.Responsible(
    abc=cfg.Abc(component_id=2738),
    login="nzinov",
)

PACKAGE_PATH = "alice/hollywood/shards/general_conversation/prod/hollywood_package.json"
RESOURSE_TYPE = "HOLLYWOOD_GENERAL_CONVERSATION_PACKAGE"
TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO = "GET_HOLLYWOOD_YAPPY_BETA_INFO"
LAST_RELEASE_NANNY = "general-conversation-ru-protocol-man"
YAPPY_BETA_PARENT_NANY = "hollywood_general_conversation_no_fast_data"
YAPPY_TEMPLATE_NAME = "alice-hollywood-general-conversation"


class HollywoodGeneralConversationCfg(cfg.ReferenceBranchedConfig):
    name = NAME
    display_name = DISPLAY_NAME
    responsible = RESPONSIBLE

    class MergesCfg(cfg.ReferenceBranchedConfig.MergesCfg):
        never_merge_to_released_branches = False

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        """
        TestEnv configuration settings
        """
        trunk_task_owner = "VINS"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            build_release_job_data = (
                jg_job_data.ParentDataDict(
                    "component_resources",
                    "package.tar.gz",
                    RESOURSE_TYPE),
            )

            @property
            def _trunk_part(self):
                trunk_part = super(self.__class__, self)._trunk_part

                trunk_part.append(jg_build.JobGraphElementBuildTrunk(
                    task_name="BUILD_AND_DEPLOY_HOLLYWOOD_FAST_DATA",
                    ctx={
                        "build_system": "ya",
                        "deployer_mode": "nanny_service",
                        "nanny_service": "hollywood_general_conversation_fast_data",
                        "shard": "GeneralConversation",
                        "use_default_deploy_configs": True,
                        "yt_store_token_owner": "VINS",
                    },
                    job_params={
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        "observed_paths": [
                            "alice/hollywood/shards/general_conversation/prod/fast_data",
                            "alice/hollywood/library/scenarios/general_conversation/fast_data",
                            "alice/begemot/lib/fixlist_index/data/ru"
                        ],
                        "task_priority": 11  # SERVICE:HIGH
                    },
                    build_item="FAST_DATA_AND_RELEASE",
                    filter_targets=[
                        "alice/hollywood/shards/general_conversation/prod/fast_data",
                        "alice/hollywood/library/scenarios/general_conversation/fast_data",
                        "alice/begemot/lib/fixlist_index/data/ru"
                    ],
                ))

                return trunk_part

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="BUILD_HOLLYWOOD_PACKAGE",
                    job_params={
                        "job_name_parameter": sandbox_constants.RELEASE_BUILD_TYPE
                    },
                    out={
                        RESOURSE_TYPE: 90,
                    },
                    job_arrows=(
                        jg_arrows.ParamsData(
                            input_key="rev",
                            transform=lambda x, rm_config: x.revision,
                        ),
                    ),
                    ctx={
                        "packages": PACKAGE_PATH,
                        "raw_package": False,
                        "resource_type": RESOURSE_TYPE,
                    },
                ))
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        ctx={"beta_name_source": "STRING"},
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="patch_name",
                                transform=lambda x, rm_config: "branch-{}".format(jg_utils.get_major_release_number(x, rm_config)),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=sandbox_constants.RELEASE_BUILD_TYPE,
                                parent_job_data=self.build_release_job_data,
                            ),
                        )
                    )
                )
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name=TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                    job_params={
                        "job_name_parameter": TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "shard": "GeneralConversation",
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerGenerateBeta(
                            job_name_parameter="beta"
                        ),
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="in_tag_num",
                                    output_key="new_tag_number",
                                ),
                            )
                        ),
                        jg_arrows.ParamsData("in_branch_num", jg_utils.get_major_release_number),
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="BUILD_AND_RUN_MARKER_TESTS",
                    job_params={
                        "job_name_parameter": "BUILD_AND_RUN_MARKER_TESTS",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                            parent_job_data=(
                                jg_job_data.ParentDataCtx(
                                    input_key="vins_url",
                                    output_key="ctx_vins_hamster_url",
                                )
                            )
                        )
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="ALICE_EVO_UE_2_E",
                    job_params={
                        "job_name_parameter": "ALICE_EVO_UE_2_E",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "abc_id": 7596,
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                            parent_job_data=(
                                jg_job_data.ParentDataCtx(
                                    input_key="component_name",
                                    output_key="ctx_component_name",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="branch_num",
                                    output_key="ctx_branch_num",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="tag_num",
                                    output_key="ctx_tag_num",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="megamind_url",
                                    output_key="ctx_vins_hamster_url",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="release_ticket",
                                    output_key="ctx_release_ticket",
                                )
                            )
                        ),
                    ),
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                    job_params={
                        "job_name_parameter": "ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "repeat_failed_test": True,
                        "run_call_owner_subtask": True,
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                            parent_job_data=(
                                jg_job_data.ParentDataCtx(
                                    input_key="launch_type",
                                    output_key="ctx_component_name",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="branch_number",
                                    output_key="ctx_branch_num",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="tag_number",
                                    output_key="ctx_tag_num",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="megamind_url",
                                    output_key="ctx_vins_hamster_url",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="release_ticket",
                                    output_key="ctx_release_ticket",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="beta_name",
                                    output_key="ctx_beta_name",
                                )
                            )
                        )
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                    job_params={
                        "job_name_parameter": "ALICE_EVO_MARKER_TESTS_WRAPPER",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "run_call_owner_subtask": True,
                        "subtask_type": "ALICE_EVO_MARKER_TESTS",
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                            parent_job_data=(
                                jg_job_data.ParentDataCtx(
                                    input_key="launch_type",
                                    output_key="ctx_component_name",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="branch_number",
                                    output_key="ctx_branch_num",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="tag_number",
                                    output_key="ctx_tag_num",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="megamind_url",
                                    output_key="ctx_vins_hamster_url",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="release_ticket",
                                    output_key="ctx_release_ticket",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="beta_name",
                                    output_key="ctx_beta_name",
                                )
                            )
                        )
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="START_HOLLYWOOD_PERF_TESTING",
                    job_params={
                        "job_name_parameter": "START_HOLLYWOOD_PERF_TESTING",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=TASK_GET_HOLLYWOOD_YAPPY_BETA_INFO,
                            parent_job_data=(
                                jg_job_data.ParentDataCtx(
                                    input_key="startrek_ticket_id",
                                    output_key="ctx_release_ticket",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="testing_target_url",
                                    output_key="ctx_beta_perf_slot",
                                ),
                            )
                        )
                    ),
                    ctx={
                        "ammo_resource": 1686632539,
                        "binary_executor_release_type": "stable",
                        "startup_load_profile": "[{type: once, times: 100}]",
                        "rps_load_profile": "[{type: const, duration: 5m, ops: 100},{type: const, duration: 5m, ops: 500},{type: const, duration: 5m, ops: 1000}]",
                    },
                ))

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_stage = rm_const.ReleaseStatus.stable
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=release_stage,
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter=sandbox_constants.RELEASE_BUILD_TYPE,
                            parent_job_data=self.build_release_job_data,
                        ),
                        jg_job_triggers.JobTriggerNewTag([
                            jg_job_data.ParentDataCtx("major_release_num", "branch_number_for_tag"),
                            jg_job_data.ParentDataCtx("minor_release_num", "new_tag_number"),
                            jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                        ]),
                    ],
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                ))
                return release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        """ Notification settings """

        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                "hollywood-releases@yandex-team.ru",
            ]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "nzinov"

            queue = "ALICERELEASE"

            summary_template = u"Release " + DISPLAY_NAME + u" ver.{}"

            add_commiters_as_followers = False
            deadline = 14
            hide_commits_under_cut = True

            workflow = {
                "open": "testing",
                "testing": "deploying",
                "deploying": "production",
                "production": "close",
            }

            use_task_author_as_assignee = True
            write_merges_in_table = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ""
        dirs = [
            "alice/hollywood/library/scenarios/general_conversation"
        ]

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        max_active_branches = 4

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        resources_info = [
            cfg.ReleasedResourceInfo(
                name="package.tar.gz",
                resource_type=RESOURSE_TYPE,
                deploy=[(rm_const.ReleaseStatus.stable, LAST_RELEASE_NANNY)],
            ),
        ]
        wait_for_deploy_time_sec = 60 * 60  # 1 hour
        allow_robots_to_release_stable = True

    class Yappy(yappy_cfg.YappyBaseCfg):
        """ Config to generate yappy betas """
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name=YAPPY_TEMPLATE_NAME,
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir=YAPPY_TEMPLATE_NAME,
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name="package.tar.gz",
                                local_path="package.tar.gz",
                            ),
                        ],
                        parent_service=YAPPY_BETA_PARENT_NANY,
                    )
                ])
        }
        working_betas_limit = 2
