# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class HorizontalPodAutoscalerControllerCfg(configs.ReferenceBranchedConfig):
    """
        Horizontal Pod Autoscaler Controller for Y.Deploy.
    """

    name = "horizontal_pod_autoscaler_controller"
    responsible = "amich"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "DRUG-RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SinglePackagePreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                package_names="infra/deploy/horizontal_pod_autoscaler_controller/deploy/package/package.json",
                build_apiargs={"requirements": {"disk_space": (10 << 30)}},
                use_compression=False,
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_test.JobGraphElementMetaTestBranched(
                        job_params={
                            "job_name_parameter": "BUILD_TRUNK_META_LINUX_DISTBUILD",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "targets": "infra/deploy/horizontal_pod_autoscaler_controller",
                        },
                    )
                )
                return branch_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="horizontal_pod_autoscaler_controller_package",
                    data=ri.SandboxResourceData("HORIZONTAL_POD_AUTOSCALER_CONTROLLER_PACKAGE", ttl=30),
                    deploy_infos=[ri.single_nanny_service("sas_test_horizontal_pod_autoscaler_ctl")],
                )
            ]
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "amich",
            "dkochetov",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "amich"
            queue = "HPACTLREL"
            dev_queue = "DEPLOY"
            summary_template = u"Приемка horizontal_pod_autoscaler_controller {}"
            followers = [
                "amich",
                "dkochetov",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "infra/horizontalpodautoscalercontroller/releases/"
        observed_paths = [
            "arcadia/infra/deploy/horizontal_pod_autoscaler_controller",
            "arcadia/infra/libs/controller",
            "arcadia/yp/cpp/yp",
            "arcadia/infra/libs/clients/golovan",
        ]
