# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class ImagesGraphMappingCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "images_graph_mapping"
    responsible = "ulgen4a"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "IMAGES-TESTENV"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        job_params={
                            "job_name_parameter": "HORIZON_AGENT_CONFIG",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        ctx={
                            "vertical": "IMGS",
                        },
                        out={
                            "APP_HOST_STABLE_BRANCH_IMAGES": 90,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="HORIZON_AGENT_CONFIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "stable_branch_res_id",
                                        "APP_HOST_STABLE_BRANCH_IMAGES",
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "graphs",
                            "force_start_beta": True,
                        },
                    )
                )
                IMAGES_GRAPH_METRICS_SLA_PROJECT = "aa8286386850f0df016874cc48882d44"  # Metrics SLA-project "SLA Release Machine", more info at https://metrics.yandex-team.ru/admin/sla
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        search_subtype="images",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    )
                                )
                            )
                        ),
                        ctx={
                            "sample_beta": "hamster.hamster",
                            "scraper_over_yt_pool": "mapping_images_priemka",
                            "sla_project": IMAGES_GRAPH_METRICS_SLA_PROJECT,
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        task_name="SANDBOX_CI_FIJI_EXPERIMENTS_RELEASE_RUNNER",
                        ctx={
                            "tools": ["hermione-e2e", "hermione"],
                            "service": "images",  # Suppose that it's useless parameter, used only in fiji tasks
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="hermionee2e_base_url",
                                        output_key="beta_name",
                                        transform=lambda x, params: "https://{}.hamster.yandex.ru".format(x),
                                    )
                                )
                            )
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 1440),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="images",
                            ),
                            jg_job_triggers.JobTriggerE2ETest(),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="images",
                            ),
                            jg_job_triggers.JobTriggerE2ETest(),
                        )
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="HORIZON_AGENT_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "stable_branch_res_id",
                                            "APP_HOST_STABLE_BRANCH_IMAGES",
                                        ),
                                    )
                                )
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="images_graph_mapping",
                resource_type="APP_HOST_STABLE_BRANCH_IMAGES",
                resource_name="stable_branch_res_id",
                deploy=[(rm_const.ReleaseStatus.stable, "production_app_host_vla_imgs_yp")],
            ),
        ]
        release_followers_permanent = [
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "ulgen4a"
            queue = "SEAREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка Images Mapping {}"
            workflow = {}
            followers = [
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True

            @property
            def banned_people(self):
                return super(self.__class__, self).banned_people | {"zhshishkin"}

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "serp/report/releases/images-mapping/"
        dirs = [
            "arcadia/apphost/conf/verticals/IMGS",
            "arcadia/apphost/conf/backends",
        ]

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        """Metrics configuration"""
        limit_s = None

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/imgs"
        tag_name = "apphost/conf/imgs"

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyBetaCfg(
                beta_name="app-host-graphs-imgs",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="app-host-graphs-imgs-graphs",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(local_path="stable_branch", param_name="stable_branch_res_id"),

                            # Nora migration hack (roboslone@).
                            yappy_cfg.YappyStaticResource("horizon_agent.ctype-geo.yaml", manage_type="SANDBOX_RESOURCE", resource_id="1656320577"),
                        ],
                        parent_service="hamster_app_host_vla_imgs_yp",
                        ignore_instance_spec=True,
                    ),
                ],
            )
        }
