# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils

from sandbox.projects.common.constants import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg


class ImagesReportCfg(configs.ReferenceBranchedConfig):
    name = "images_report"
    display_name = u"Images Report"
    responsible = "anskor"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "IMAGES-TESTENV"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_REPORT_CORE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="report_arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "project": "IMGS",
                        },
                        out={
                            "REPORT_IMAGES_CORE_PACKAGE": 30,
                        },
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="images_report_core_package",
                                        resource_name="REPORT_IMAGES_CORE_PACKAGE",
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "demo",
                            "update_beta_mode": "REPLACE",
                        },
                    ),
                    jg_test.JobGraphElementE2ETest(
                        task_name="SANDBOX_CI_FIJI_EXPERIMENTS_RELEASE_RUNNER",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="hermionee2e_base_url",
                                        output_key="beta_name",
                                        transform=lambda x, params: "https://{}.hamster.yandex.ru".format(x),
                                    )
                                )
                            )
                        ),
                        ctx={
                            "tools": ["hermione-e2e", "hermione"],
                            "platforms": ["desktop", "touch-pad", "touch-phone", "tv"],
                            "service": "images",
                        },
                    ),
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=(
                            jg_job_triggers.JobTriggerE2ETest(),
                        ),
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "images_report_core_package",
                                        "REPORT_IMAGES_CORE_PACKAGE",
                                    )
                                )
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="images_report_core_package",
                resource_type="REPORT_IMAGES_CORE_PACKAGE",
                deploy=[(rm_const.ReleaseStatus.stable, "production_report_vla_imgs_rkub")],
            ),
        ]
        allow_old_releases = True
        release_followers_permanent = [
            "anskor", "fexion"
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "anskor"
            queue = "BETATEST"
            dev_queue = "IMAGES"
            summary_template = u"Приемка images report {}"
            components = u"images_report"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "anskor",
                "fexion"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            nanny_reports = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "yandeximages/runtime/report-releases/"
        dirs = [
            "arcadia/web/report",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "images/report"
        tag_name = "images/report"

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyBetaCfg(
                beta_name="report-images-demo",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="report-images-demo",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="report_core.tar", param_name="images_report_core_package"
                            )
                        ],
                        parent_service="hamster_report_vla_imgs_all",
                    ),
                ],
            ),
        }
