from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components.config_core.jg.cube.base import CubeInput
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import SearchReleasesBuildTestCube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.metrics import SearchLaunchMetricsImages
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base.images import TestE2ETestsImages


class ImagesSrcSetupTestsBundle():
    @staticmethod
    def get_bundle(build_tests_target_path, build_tests_needs, beta_cube, soy_pool):
        """
        Returns list of build meta tests and tests of beta

        :type build_tests_target_path: str
        :param build_tests_target_path:
            Arcadia path to tests

        :type build_tests_needs: Iterable[Cube]
        :param build_tests_needs:
            Dependencies for build tests

        :type beta_cube: Cube
        :param beta_cube:
            The name of the beta cube beta tests depends on

        :type soy_pool: str
        :param soy_pool:
            The name of the soy_pool for search integration tests of beta

        :return: List[MetaTestAsanTestsCube, MetaTestDiffTestsCube, MetaTestTsanTestsCube
            TestE2ETestsCube, LaunchMetricsCube]
        """

        sanitizers = (
            "address",
            None,
            "thread",
        )

        return [
            SearchReleasesBuildTestCube(
                name="ya_make_{}_sanitizer_test".format(sanitizer) if sanitizer else "ya_make_diff_test",
                needs=build_tests_needs,
                input=CubeInput(**{
                    "targets": build_tests_target_path,
                    sandbox_constants.SANITIZE: sanitizer,
                }),
            ) for sanitizer in sanitizers
        ] + [
            TestE2ETestsImages(beta_cube),
            SearchLaunchMetricsImages.by_generate_beta_cube(beta_cube, scraper_over_yt_pool=soy_pool),
        ]
