# -*- coding: utf-8 -*-

import os
from sandbox.projects.release_machine.core import const as rm_const
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import IceFlamePatched
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components.configs.images_src_setup import ImagesSrcSetupTestsBundle


# ya make tasks
BINARY_PATH = "web/src_setup/daemons/vertical/IMGS/src_setup"
CONFIG_PATH = "web/src_setup/conf/vertical/IMGS/static_config"
INSTANCECTL_CONFIG_PATH = "web/src_setup/deploy/vertical/IMGS/instancectl.conf"
EVENT_LOG_DUMP_PATH = "web/src_setup/tools/event_log_dump"
PUSH_CLIENT_YAML_DUMP_PATH = "web/src_setup/conf/vertical/IMGS/push_client"
ASAN_TSAN_DIFF_TESTS_PATH = "web/src_setup/tests/pseudo_src_setup/IMGS"

# global variables
CHAT_NAME = "src_setup_releases_images::telegram"
PARENT_SERVICE = "hamster_src_setup_vla_imgs_yp"  # for iceflame and yappy


class ImagesSrcSetupCfg(configs.ReferenceCIConfig):
    name = "images_src_setup"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="images"),
        login="evseevd",
    )

    # metrics launch
    component_group = "reference_component_metricsed"

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        # JG params and stages init
        add_beta_generator = "images"

        # configuring auto-deploy
        release_manually = False

        @jg_flow.release_flow(stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(self.__class__, self).release(self)

            main_stage_entry_cube = graph.get("main_graph_entry")
            beta_cube = graph.get("generate_beta__images_src_setup__images")
            release_entry_cube = graph.get("release_stage_entry")

            #  tests init
            tests = ImagesSrcSetupTestsBundle.get_bundle(
                build_tests_target_path=ASAN_TSAN_DIFF_TESTS_PATH,
                build_tests_needs=[main_stage_entry_cube],
                beta_cube=beta_cube,
                soy_pool="src_setup_web_priemka",
            )

            # add cubes to graph
            for test in tests:
                release_entry_cube.add_requirement(test)
                graph.add(test)

            return graph

        def _get_build_cube(self, graph):
            targets = []
            artifacts = []
            source_artifacts = []
            resource_types = []

            for item in self.suitable_releasable_items:
                targets.append(item.build_data.target)
                if item.build_data.is_source:
                    source_artifacts.append(item.build_data.artifact)
                else:
                    artifacts.append(item.build_data.artifact)
                resource_types.append(item.data.resource_type)

            return build_cubes.YaMakeBuildCubeBase(
                name=self.build_cube_name,
                task=self.build_task,
                targets=targets,
                artifacts=artifacts,
                source_artifacts=source_artifacts,
                resource_types=resource_types,
                input=jg_cube.CubeInput(
                    result_attrs={
                        "major_release_num": rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                        "minor_release_num": rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
                    },
                    thinlto=True,
                ),
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )

        # activate Morty release
        def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
            return [
                release_cubes.ScheduleRelease(
                    name="release_{}_{}".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    flows=["deploy"],
                    warden_component_name="src_setup",
                    warden_parent_component_name="images",
                    deploy_system=deploy_system,
                    schedule_mode="create_and_schedule",
                    input=jg_cube.CubeInput(
                        component_resources={
                            ri.name: build.output.resources[ri.data.resource_type].first().id
                            for ri in releasable_items
                        },
                    ),
                    manual=self.release_manually,
                ),
            ]

        @jg_flow.register_flow(title="Run IceFlame")
        def run_iceflame(self):
            return graph_base.Graph([IceFlamePatched(ImagesSrcSetupCfg.name, "images_src_setup_binary", PARENT_SERVICE, "src_setup.conf")])

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = BINARY_PATH
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            os.path.join(BINARY_PATH, "**"),
            os.path.join(CONFIG_PATH, "**"),
        ]

    class Releases(configs.ReferenceCIConfig.Releases):

        allow_old_releases = True
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            def release_it(name, resource_type, dst_path, target, artifact_name, deploy_infos):
                return ri.ReleasableItem(
                    name,
                    data=ri.SandboxResourceData(resource_type, dst_path=dst_path),
                    build_data=ri.BuildData(
                        target=target,
                        artifact=os.path.join(target, artifact_name),
                    ),
                    deploy_infos=deploy_infos,
                )

            hamster_services = [
                "hamster_src_setup_sas_imgs_yp",
                "hamster_src_setup_man_imgs_yp",
                "hamster_src_setup_vla_imgs_yp",
            ]

            production_services = [
                "production_src_setup_sas_imgs_yp",
                "production_src_setup_man_imgs_yp",
                "production_src_setup_vla_imgs_yp",
            ]

            release_deploy_infos = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService(service, tags=["hamster"]) for service in hamster_services
                    ] + [
                        ri.DeployService(service, tags=["production"]) for service in production_services
                    ]
                ),
            ]

            return [
                release_it(
                    name="images_src_setup_binary",
                    resource_type="IMAGES_SRC_SETUP_BINARY",
                    dst_path="src_setup",
                    target=BINARY_PATH,
                    artifact_name="src_setup",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="images_src_setup_config",
                    resource_type="IMAGES_SRC_SETUP_CONFIG",
                    dst_path="config.json",
                    target=CONFIG_PATH,
                    artifact_name="config.json",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="images_src_setup_instancectl_config",
                    resource_type="IMAGES_SRC_SETUP_INSTANCECTL_CONFIG",
                    dst_path="instancectl.conf",
                    target=INSTANCECTL_CONFIG_PATH,
                    artifact_name="instancectl.conf",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="images_src_setup_event_log_dump",
                    resource_type="SRC_SETUP_EVENT_LOG_DUMP",
                    dst_path="event_log_dump",
                    target=EVENT_LOG_DUMP_PATH,
                    artifact_name="event_log_dump",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="images_src_setup_push_client_yaml",
                    resource_type="IMAGES_SRC_SETUP_PUSH_CLIENT_YAML",
                    dst_path="push_client.yaml",
                    target=PUSH_CLIENT_YAML_DUMP_PATH,
                    artifact_name="push_client.yaml",
                    deploy_infos=release_deploy_infos,
                ),
                ri.DynamicReleasableItem(
                    name="scheduled_bundle",
                    data=ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    deploy_infos=[ri.NannyDeployInfo()],
                ),
            ]

    class Yappy(configs.ReferenceCIConfig.Yappy):
        betas = {
            "images": yappy_cfg.YappyTemplateCfg(
                template_name="src-setup-images-ci",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="src-setup-images-ci",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="instancectl.conf",
                                param_name="images_src_setup_instancectl_config",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="src_setup",
                                param_name="images_src_setup_binary",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="event_log_dump",
                                param_name="images_src_setup_event_log_dump",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="config.json",
                                param_name="images_src_setup_config",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="push_client.yaml",
                                param_name="images_src_setup_push_client_yaml",
                            ),
                        ],
                        parent_service=PARENT_SERVICE,
                    ),
                ],
            ),
        }

    class Notify(configs.ReferenceCIConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewBetaGeneration",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name=CHAT_NAME,
                message_template_file="notifications/src_setup/ticket_history.html",
                pin=True,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="ticket_history_data.ticket_history_latest_status",
                            operator="TEXT_EXACTLY_IS",
                            value="open",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="ci_job_instance_id.job_id",
                            operator="TEXT_EXACTLY_IS",
                            value="create_startrek_ticket",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="ci_job_context.version_info.minor",
                            operator="TEXT_EXACTLY_IS",
                            value="",
                        ),
                    ],
                    join_strategy="AND",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="MetaTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="AND",
                ),
                message_template_file="notifications/src_setup/meta_test.html",
            ),
            rm_notifications.Notification(
                event_type="GenericTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="AND",
                ),
                message_template_file="notifications/src_setup/generic_test.html",
            ),
            rm_notifications.Notification(
                event_type="AcceptanceTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="OR",
                ),
            ),
        ]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = [CHAT_NAME]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/+PXFXiIPqMUJmYTAy"

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "evseevd"
            queue = "SRCSETUPRELIMGS"
            dev_queue = "SEARCH"
            summary_template = u"Приемка Images Src Setup {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "evseevd",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

            @property
            def banned_people(self):
                return super(self.__class__, self).banned_people | {"zhshishkin"}

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        observed_paths = [
            "arcadia/web/src_setup"
        ]

        use_previous_branch_as_baseline = True

    class MetricsCfg(configs.ReferenceCIConfig.MetricsCfg):
        limit_s = None

    class ReleaseViewer(configs.ReferenceCIConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]
