# -*- coding: utf-8 -*-

import os
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets

from sandbox.projects.release_machine.components.config_core.jg.cube.lib.infra.service_controller import ServiceControllerDiffTest


EXECUTABLE_PATH = "infra/service_controller/daemons/service_controller"


class ServiceControllerCfg(configs.ReferenceCIConfig):
    name = "service_controller"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="service_discovery"),
        login="avitella",
    )
    robot = "robot-ci-srvc-ctrl"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = EXECUTABLE_PATH
        secret = "sec-01g111jgk0gpj817apy2nnrvs1"
        sb_owner_group = "YP-DNS"

        ya_make_abs_paths_glob = [
            os.path.join(EXECUTABLE_PATH, "**"),
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "KOSHER_YA_MAKE"

        @jg_flow.release_flow(stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(self.__class__, self).release(self)

            build_cube = graph.get("build")
            release_entry_cube = graph.get("release_stage_entry")

            diff_test = ServiceControllerDiffTest(build_cube)
            diff_test.add_requirement(build_cube)
            release_entry_cube.add_requirement(diff_test)
            graph.add(diff_test)

            return graph

    class Releases(configs.ReferenceCIConfig.Releases):
        """Releases configuration"""
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="service_controller",
                    build_data=ri.BuildData(
                        target=EXECUTABLE_PATH,
                        artifact=os.path.join(EXECUTABLE_PATH, "service_controller"),
                    ),
                    data=ri.SandboxResourceData("SERVICE_CONTROLLER_BINARY"),
                    deploy_infos=[
                        ri.NannyDeployInfo([
                            ri.DeployService("sas_test_yp_service_controller"),
                            ri.DeployService("man_pre_yp_service_controller"),
                            ri.DeployService("iva_yp_service_controller"),
                            ri.DeployService("myt_yp_service_controller"),
                            ri.DeployService("vla_yp_service_controller"),
                            ri.DeployService("man_yp_service_controller"),
                            ri.DeployService("sas_yp_service_controller"),
                            ri.DeployService("xdc_yp_service_controller"),
                        ]),
                    ]
                ),
            ]

        release_followers_permanent = [
            "avitella",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "avitella"
            queue = "SRVCTLREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка service_controller {}"
            workflow = {}
            followers = [
                "avitella",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "infra/servicecontroller/releases/"
        dirs = [
            "arcadia/infra/service_controller",
            "arcadia/infra/libs/controller",
            "arcadia/yp/cpp/yp",
        ]
        review_groups = [
            "yp-sc",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 57  # moved to the CI since the 57th branch, 56th released by TE
        use_arc = True
