# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.configs.basesearch import notifications_template, workflow_template
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as common_const


class IntL1Cfg(configs.ReferenceBranchedConfig):
    name = "int_l1"
    display_name = "Web Int L1"
    responsible = "okats"
    component_group = "reference_component_metricsed"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"
        testenv_db_owners = ["andreikkaa"]
        trunk_db = "ws-int-l1-trunk"
        branch_db_template = "ws-int-l1-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MIDDLESEARCH_2",
                        ctx={
                            "target_resources": ["L1_INTSEARCH_EXECUTABLE", "INTSEARCH_EXECUTABLE", "EVLOGDUMP_EXECUTABLE", "LOGANALYZE_EXECUTABLE", "EVLOGSAMPLE_EXECUTABLE"],
                            "build_system": common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
                            "notify_if_failed": "SEARCH-RELEASERS",
                            "thinlto": True,
                            common_const.DEFINITION_FLAGS_KEY: '-DCFLAGS="-fno-omit-frame-pointer"',
                        },
                        out={"L1_INTSEARCH_EXECUTABLE": 90, "INTSEARCH_EXECUTABLE": 90},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="int_l1",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "int_l1_executable_res_id",
                                        "L1_INTSEARCH_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "priemka",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="INT_L1",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "custom_template_name": "common.json",
                            "sample_beta": "hamster",
                            "scraper_over_yt_pool": "base_web_priemka",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="WEB"
                            ),
                        ),
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="int_l1",
                                        resource_name="L1_INTSEARCH_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="int",
                                        resource_name="INTSEARCH_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )

                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="int_l1",
                    data=ri.SandboxResourceData("L1_INTSEARCH_EXECUTABLE", ttl=100),
                    deploy_infos=[ri.single_nanny_service("{}-web-int-resources".format(location)) for location in rm_const.MAIN_LOCATIONS],
                ),
                ri.ReleasableItem(
                    name="int",
                    data=ri.SandboxResourceData("INTSEARCH_EXECUTABLE", ttl=100),
                    deploy_infos=[ri.single_nanny_service("{}-web-int-resources".format(location)) for location in rm_const.MAIN_LOCATIONS],
                ),
            ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        notifications = notifications_template

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["base_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/CaUODkKTwtMdwenQIkLLKQ"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "andreikkaa"
            queue = "BASEREL"
            dev_queue = "SEARCH"
            summary_template = "Int L1 acceptance {}"
            use_task_author_as_assignee = True
            workflow = workflow_template
            add_commiters_as_followers = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/intl1/releases/"
        ya_make_targets = [
            "search/daemons/l1_intsearch",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "int_l1": yappy_cfg.YappyBetaCfg(
                beta_name="multifullbeta2-web-priemka",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="multifullbeta2-web-priemka",
                        resources=[
                            yappy_cfg.YappyStaticResource(local_path="mmeta.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="intsearch.executable", param_name="int_l1_executable_res_id"
                            ),
                            yappy_cfg.YappyStaticResource(local_path="intsearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="embedding.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="embedding.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="invindex.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="keyinv.executable", manage_type="BC_DEFAULT"),
                        ]
                    )
                ]
            )
        }
