from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


def binary_task_branched_build_item(task_type):
    return "DEPLOY_BINARY_TASK_{}".format(task_type)


def binary_task_trunk_build_item(task_type):
    return "DEPLOY_BINARY_TASK_TRUNK_{}".format(task_type)


def build_binary_task_branched(target, task_type):
    return jg_build.JobGraphElementBuildBranched(
        task_name="DEPLOY_BINARY_TASK",
        build_item=binary_task_branched_build_item(task_type),
        out={"SANDBOX_TASKS_BINARY": 60},
        ctx={
            "target": target,
            "attrs": {"task_type": task_type},
            "use_yt_cache": False,
        },
        job_arrows=(
            jg_triggers.JobTriggerNewTag(
                parent_job_data=[
                    jg_data.ParentDataOutput(
                        input_key="arcadia_url",
                        output_key=common_const.ARCADIA_URL_KEY,
                    ),
                ],
            )
        ),
    )


def build_binary_task_trunk(target, task_type, job_params=None):
    return jg_build.JobGraphElementBuildTrunk(
        task_name="DEPLOY_BINARY_TASK",
        build_item=binary_task_trunk_build_item(task_type),
        out={"SANDBOX_TASKS_BINARY": 60},
        ctx={
            "target": target,
            "attrs": {"task_type": task_type},
            "use_yt_cache": False,
        },
        job_arrows=(
            jg_arrows.ParamsData(
                input_key="arcadia_url",
                transform=jg_utils.arcadia_svn_url_with_revision,
            ),
        ),
        job_params=job_params
    )


def binary_tasks_releasable_item(task_type):
    return ri.ReleasableItem(
        name=task_type,
        data=ri.SandboxResourceData(
            "SANDBOX_TASKS_BINARY",
            build_ctx_key="arcadia_url",
            attributes={"task_type": task_type}
        ),
        deploy_infos=[ri.SandboxInfo()]
    )


def release_binary_task_branched(task_types, release_item, release_to, triggers=()):
    triggers = list(triggers)
    for task_type in task_types:
        triggers.append(jg_triggers.JobTriggerBuild(
            parent_job_data=(
                jg_data.ParentDataDict(
                    input_key="component_resources",
                    dict_key=task_type,
                    resource_name="SANDBOX_TASKS_BINARY",
                ),
            ),
            job_name_parameter=binary_task_branched_build_item(task_type),
        ))
    return jg_release.JobGraphElementReleaseBranched(
        task_name="RELEASE_RM_COMPONENT_2",
        release_to=release_to,
        job_params={
            "ctx": {
                "deploy_system": rm_const.DeploySystem.sandbox.name
            }
        },
        release_item=release_item,
        job_arrows=triggers
    )


def release_binary_task_trunk(task_type,
                              release_to,
                              triggers=(),
                              tags=None,
                              observed_paths=None,
                              filter_targets=None,
                              autostart_in_precommit_checks_source_database=None,
                              frequency=(jg_utils.TestFrequency.LAZY, None)):
    triggers = list(triggers)
    triggers.append(jg_triggers.JobTriggerBuild(
        parent_job_data=(
            jg_data.ParentDataDict(
                input_key="component_resources",
                dict_key=task_type,
                resource_name="SANDBOX_TASKS_BINARY",
            ),
        ),
        job_name_parameter=binary_task_trunk_build_item(task_type),
    ))

    job_params = {
        "ctx": {
            "deploy_system": rm_const.DeploySystem.sandbox.name,
            "skip_on_empty_arcadia_patch": False
        },
        "should_add_to_db": jg_utils.should_add_to_db_trunk,
    }

    if tags is not None:
        job_params["tags"] = tags
    if observed_paths is not None:
        job_params["observed_paths"] = observed_paths
    if filter_targets is not None:
        job_params["filter_targets"] = filter_targets
    if autostart_in_precommit_checks_source_database is not None:
        job_params["ctx"]["skip_on_empty_arcadia_patch"] = True
        job_params["autostart_in_precommit_checks_source_database"] = autostart_in_precommit_checks_source_database
    if frequency is not None:
        job_params["frequency"] = frequency

    return jg_release.JobGraphElementReleaseBase(
        task_name="RELEASE_RM_COMPONENT_2",
        release_to=release_to,
        job_params=job_params,
        release_item=task_type,
        job_arrows=triggers
    )


def release_binary_task_trigger(task_type, release_to):
    return jg_triggers.JobTriggerRelease(job_name_parameter='{}__{}'.format(task_type, release_to))


def action_release_binary_task(release_item, release_to, frequency=(jg_utils.TestFrequency.LAZY, None)):
    return jg_release.JobGraphElementActionReleaseBranched(
        job_params={
            "frequency": frequency
        },
        release_to=release_to,
        release_item=release_item,
    )
