# -*- coding: utf-8 -*-

import os

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs.irt import _binary_task_common
from sandbox.projects.release_machine.components.job_graph import job_data as jg_data
from sandbox.projects.release_machine.components.job_graph import job_triggers as jg_triggers
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils

BINARY_TASKS = (
    ("sandbox/projects/irt/bmgen/CatalogiaCampaigns/bin/bin", "BMGEN_CATALOGIA_CAMPAIGNS"),
    ("sandbox/projects/irt/bmgen/FreqWordforms/FreqWordforms", "BMGEN_FREQ_WORDFORMS"),
    ("sandbox/projects/irt/bmgen/MakeGeneratedDicts/MakeGeneratedDicts", "BMGEN_MAKE_GENERATED_DICTS"),
    ("sandbox/projects/irt/bmgen/MarketData/MarketData", "BMGEN_MARKET_DATA"),
    ("sandbox/projects/irt/bmgen/NormAndWordcountDicts/bin/bin", "BMGEN_NORM_AND_WORDCOUNT_DICTS"),
    ("sandbox/projects/irt/bmgen/Synonyms/Synonyms", "BMGEN_SYNONYMS"),
    ("sandbox/projects/irt/bmgen/Word2SnormDict/Word2SnormDict", "BMGEN_WORD_2_SNORM_DICT"),
)

SANDBOX_TASKS_RELEASE_ITEM = "SANDBOX_TASKS"


class BmgenCfg(configs.ReferenceBranchedConfig):
    name = "bmgen"
    display_name = u"[IRT] Bmgen"
    responsible = configs.Responsible(abc=configs.Abc(component_id=1158, role_id=None), login="fawkes")

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "IRT/bmgen/releases/"
        ya_make_targets = [os.path.dirname(target) for target, _ in BINARY_TASKS]

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "IRT"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                for target, binary_task_name in BINARY_TASKS:
                    branch_part.append(_binary_task_common.build_binary_task_branched(target, binary_task_name))
                return branch_part

            @property
            def _trunk_part(self):
                trunk_part = super(self.__class__, self)._trunk_part

                for target, binary_task_name in BINARY_TASKS:
                    trunk_part.append(_binary_task_common.build_binary_task_trunk(target, binary_task_name))
                return trunk_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release

                for _, task_type in BINARY_TASKS:
                    release_part.append(
                        _binary_task_common.release_binary_task_trunk(
                            task_type=task_type,
                            release_to=rm_const.ReleaseStatus.prestable,
                            triggers=(),
                            filter_targets=[os.path.dirname(target) for target, _ in BINARY_TASKS],
                            frequency=(jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 10)
                        )
                    )

                release_part.append(
                    _binary_task_common.release_binary_task_branched(
                        [task_type for _, task_type in BINARY_TASKS],
                        SANDBOX_TASKS_RELEASE_ITEM,
                        rm_const.ReleaseStatus.stable,
                        [jg_triggers.JobTriggerNewTag([
                            jg_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                            jg_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                        ])],
                    )
                )

                release_part.append(
                    _binary_task_common.action_release_binary_task(
                        SANDBOX_TASKS_RELEASE_ITEM,
                        rm_const.ReleaseStatus.stable,
                        (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    )
                )

                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        release_followers_permanent = ["fawkes"]
        wait_for_deploy_time_sec = 5 * 60  # 5 min
        deploy_system = rm_const.DeploySystem.sandbox

        @property
        def releasable_items(self):
            return [_binary_task_common.binary_tasks_releasable_item(task_type) for _, task_type in BINARY_TASKS]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = "IRTRELEASE"
            assignee = "fawkes"
            ticket_type = "Release"
            summary_template = u"[IRT] Bmgen release {}"
            workflow = rm_const.Workflow.BETA_TEST
            add_commiters_as_followers = False
            followers = []
