# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class IrtBotCfg(configs.ReferenceCIConfig):
    name = "irt_bot"
    display_name = u"IRT bot"
    responsible = configs.Responsible(abc=configs.Abc(component_id=1158, role_id=None), login='danila-eremin')

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        observed_paths = [
            "arcadia/rt-research/common/tools/bot",
        ]
        wiki_page = "IRT/IRT-bot/releases/"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "rt-research/common/tools/bot"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "IRT"
        grant_config_update_permissions_to_release_machine_robot = True

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):
            @property
            def _release(self):
                release_part = super(self.__class__, self)._release

                release_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="BUILD_IRT_BOT",
                    out={"IRT_DATA": 60},
                ))

                frequency = {
                    rm_const.ReleaseStatus.stable: (jg_utils.TestFrequency.LAZY, None),
                    rm_const.ReleaseStatus.prestable: (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                }

                for release_stage in frequency:
                    release_part.append(jg_release.JobGraphElementReleaseCI(
                        release_to=release_stage,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.ya_deploy.name,
                            }
                        },
                        job_arrows=jg_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_data.ParentDataDict(
                                    input_key="component_resources",
                                    dict_key="irt_bot",
                                    resource_name="IRT_DATA",
                                ),
                            ],
                        )
                    ))
                return release_part

    class Releases(configs.ReferenceCIConfig.Releases):
        release_followers_permanent = ["danila-eremin"]
        wait_for_deploy_time_sec = 5 * 60  # 5 min
        deploy_system = rm_const.DeploySystem.ya_deploy

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=self.name,
                    data=ri.SandboxResourceData("IRT_DATA"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("irt-bot-stage")),
                        ri.YaDeployInfo(
                            ri.DeployService("irt-bot-prestable-stage"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                    ]
                ),
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            queue = "IRTRELEASE"
            assignee = "danila-eremin"
            ticket_type = "Release"
            summary_template = u"Irt bot release {}"
            workflow = rm_const.Workflow.BETA_TEST
            add_commiters_as_followers = False
            followers = []

        class Mail(configs.ReferenceCIConfig.Notify.Mail):
            mailing_list = [
                "danila-eremin@yandex-team.ru"
            ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 3
