# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube


class RunMakePocketCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    name = "run_make_pocket"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="bannerland"),
        login="nemal300",
    )
    target_task_path = "sandbox/projects/irt/bannerland/bin"
    target_task_path_no_bin = target_task_path
    target_bin_name = "bin"
    target_task_type = "BANNERLAND_RUN_MAKE_POCKET"
    target_task_ci_registry_location = "projects/irt/run_make_pocket"
    release_to_stable_manually = True
    add_precommit_check = True
    add_prestable_auto_release = True

    @property
    def test_run_input(self):
        return [
            jg_cube.CubeInput(
                bannerland_task_type="perf",
                run_env="preprod",
                bannerland_make_banners_mode="blrt",
                yt_root="",
                maker_id=0,
                use_last_taskbin=True,
                use_native_sandbox_release=True,
                taskbin_release_type="testing",
                taskbin_resource=None,
                yt_token="sec-01fwvy7a315nm5hb004g70cmmb#yt_token",
                yql_token="sec-01g8ka4dxs7k63nm0b36sm2mws#yql_token",
            ),
            jg_cube.CubeInput(
                bannerland_task_type="dyn",
                run_env="preprod",
                bannerland_make_banners_mode="blrt",
                yt_root="",
                maker_id=0,
                use_last_taskbin=True,
                use_native_sandbox_release=True,
                taskbin_release_type="testing",
                taskbin_resource=None,
                yt_token="sec-01fwvy7a315nm5hb004g70cmmb#yt_token",
                yql_token="sec-01g8ka4dxs7k63nm0b36sm2mws#yql_token",
            ),
        ]

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = "BANNERLAND"
