# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube


class TopClientsMonitorCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    name = "top_clients_monitor"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="bannerland"),
        login="optozorax",
    )
    target_task_path = "rt-research/bannerland/monitoring/top_clients_monitor/sandbox_task"
    target_task_path_no_bin = target_task_path
    target_bin_name = "sandbox_task"
    target_task_type = "TOP_CLIENTS_MONITOR"
    target_task_ci_registry_location = "projects/irt/top_clients_monitor"
    release_to_stable_manually = True
    add_precommit_check = True

    @property
    def test_run_input(self):
        return jg_cube.CubeInput(
            binary_release_parameters="testing",
            yt_token="sec-01g4d9mp2q209szcq4v52fvztq",
            yql_token="sec-01g6j7q3x4ekwzrcm6jvy3aq6d",
            solomon_token="sec-01g4d9p2s4rejgeccyrp9sv222",
        )

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = "BANNERLAND"
