# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube


class UpdateDynTrashfilterCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    name = "update_dyn_trashfilter"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="bannerland"),
        login="optozorax",
    )
    target_task_path = "rt-research/bannerland/resource_generation/update_dyn_trashfilter/sandbox_task"
    target_task_path_no_bin = target_task_path
    target_bin_name = "update_dyn_trashfilter"
    target_task_type = "UPDATE_DYN_TRASHFILTER"
    target_task_ci_registry_location = "projects/irt/update_dyn_trashfilter"
    release_to_stable_manually = True
    add_precommit_check = True

    @property
    def test_run_input(self):
        return jg_cube.CubeInput(
            binary_release_parameters="testing",
            yt_token="sec-01g4d9mp2q209szcq4v52fvztq",
            stat_days=10,
            ban_window_days=5,
        )

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = "BANNERLAND"
