# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs


class ItdItpMiddleCfg(configs.ReferenceBranchedConfig):
    name = "itditp_middle"
    responsible = "ulyanin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "itditp-middle-trunk"
        trunk_task_owner = "SEARCH-RELEASERS"
        branch_db_template = "itditp-middle-{testenv_db_num}"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="itditp_middle",
                resource_type="ITDITP_MIDDLESEARCH_EXECUTABLE",
                resource_name="itditp_middle_res_id",
            ),
        ]
        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["itditp_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "ulyanin"
            queue = "ITDITPMIDDLEREL"
            dev_queue = "ITDITP"
            summary_template = u"Приёмка рекомендаций {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "ulyanin",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/KachestvoPoiska/itditp-middle/releases/"
        dirs = [
            "arcadia/search/daemons/ranking_itditp_middlesearch",
        ]
        review_groups = [
            "base",
        ]
