# -*- coding: utf-8 -*-


from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
# from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
# import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test

# CM_RESOURCES = {
#     "BLRT_CMPY": "cmpy",
#     "BLRT_CM_BINARIES": "cm_binaries",
#     "BLRT_CM_WORKER_CONFIGS": "worker_configs",
# }

# WORKER_RESOURCES = {
#     "BLRT_WORKER": "worker",
#     "BLRT_WORKER_CONFIGS": "worker_configs",
#     "BLRT_LOGFETCHER": "logfetcher",
#     "BLRT_PREPARE_PERL_ENV": "prepare_perl_env",
#     "BLRT_BM_BANNERLAND_LIB": "bm_bannerland_lib",
# }

# RESHARDER_RESOURCES = {
#     "BLRT_RESHARDER": "resharder",
# }

# TASK_WORKER_RESOURCES = {
#     "BLRT_TASK_WORKER": "task_worker",
# }

# SELECTION_RANK_WORKER_RESOURCES = {
#     "BLRT_SELECTION_RANK_WORKER": "selection_rank_worker",
# }

# OFFER_WORKER_RESOURCES = {
#     "BLRT_OFFER_WORKER": "offer_worker",
# }

# PREVIEW_WORKER_RESOURCES = {
#     "BLRT_PREVIEW_WORKER": "preview_worker",
# }

VIEWER_RESOURCES = {
    "JUNK_OPTOZORAX_BLRT_VIEWER": "viewer",
}


class JunkOptozoraxBlrtCfg(configs.ReferenceBranchedConfig):
    name = "junk_optozorax_blrt"
    responsible = configs.Responsible(abc=configs.Abc(service_name="irt"), login="optozorax")

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "IRT"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):

            @property
            def _branch_part(self):
                def get_build_bundle_element(job_name, resources):
                    return jg_build.JobGraphElementBuildPackageBranched(
                        task_name="YA_PACKAGE_2",
                        job_params={"job_name_parameter": job_name},
                        package_names=";".join(["robot/blrt/packages/{}/pkg.json".format(package) for _, package in resources.items()]),
                        resource_names=";".join([resource for resource, _ in resources.items()]),
                        use_compression=False,
                        ctx={
                            "package_type": "tarball",
                            "raw_package": True,
                            # sandbox_constants.YA_YT_DIR: "//home/jupiter/yamake_cache",
                            # sandbox_constants.YA_YT_PROXY: "arnold.yt.yandex.net",
                            # sandbox_constants.YA_YT_PUT: True,
                            # sandbox_constants.YA_YT_STORE: True,
                            # sandbox_constants.YA_YT_TOKEN_VAULT_NAME: "jupiter_yt_token",
                            # sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: "JUPITER",
                        },
                        out={resource: 100 for resource, _ in resources.items()},
                    )

                # worker_bundle_resources = WORKER_RESOURCES.copy()
                # worker_bundle_resources.update(RESHARDER_RESOURCES)
                # worker_bundle_resources.update(TASK_WORKER_RESOURCES)
                # worker_bundle_resources.update(SELECTION_RANK_WORKER_RESOURCES)
                # worker_bundle_resources.update(OFFER_WORKER_RESOURCES)
                # worker_bundle_resources.update(PREVIEW_WORKER_RESOURCES)

                branch_part = super(self.__class__, self)._branch_part
                # branch_part.append(get_build_bundle_element("CM_BUNDLE", CM_RESOURCES))
                # branch_part.append(get_build_bundle_element("WORKER_BUNDLE", worker_bundle_resources))
                branch_part.append(get_build_bundle_element("JUNK_OPTOZORAX_VIEWER_BUNDLE", VIEWER_RESOURCES))

                # ------------- NEW \/  \/  \/  \/  \/  \/  \/  \/  \/  \/
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="DEPLOY_BINARY_TASK",
                    job_params={"job_name_parameter": "BUILD_JUNK_OPTOZORAX_SANDBOX_TASK"},
                    build_item="DEPLOY_BINARY_TASK_{}".format("BUILD_BANNER_LAND_BINARY_RESOURCES"),
                    out={"SANDBOX_TASKS_BINARY": 60},
                    ctx={
                        "target": "irt/bannerland/legacy/generation/configs/sandbox_task",
                        "attrs": {"task_type": "BUILD_BANNER_LAND_BINARY_RESOURCES"},
                        "use_yt_cache": False,
                        "release_ttl": 14,
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=[
                                jg_job_data.ParentDataOutput(
                                    input_key="arcadia_url",
                                    output_key=common_const.ARCADIA_URL_KEY,
                                ),
                            ],
                        )
                    ),
                ))
                branch_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                    release_item="SANDBOX_TASKS_BINARY",
                    job_params={"job_name_parameter": "RELEASE_JUNK_OPTOZORAX_SANDBOX_TASK"},
                    job_arrows=(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="BUILD_JUNK_OPTOZORAX_SANDBOX_TASK",
                            parent_job_data=[
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "sandbox_tasks_binary",
                                    "SANDBOX_TASKS_BINARY",
                                ),
                            ]
                        )
                    )
                ))
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="BUILD_BANNER_LAND_BINARY_RESOURCES",
                    job_params={"job_name_parameter": "RUN_JUNK_OPTOZORAX_SANDBOX_TASK"},
                    build_item="RUN_{}".format("BUILD_BANNER_LAND_BINARY_RESOURCES"),
                    out={"BANNERLAND_GENERATION_MODELS": 60},
                    ctx={},
                    job_arrows=(
                        jg_job_triggers.JobTriggerRelease(
                            job_name_parameter="RELEASE_JUNK_OPTOZORAX_SANDBOX_TASK",
                        ),
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="BUILD_JUNK_OPTOZORAX_SANDBOX_TASK",
                            parent_job_data=(
                                jg_job_data.TasksArchiveParentDataOutput(
                                    "SANDBOX_TASKS_BINARY",
                                ),
                            ),
                        ),
                    ),
                ))
                # ------------- NEW /\  /\  /\  /\  /\  /\  /\  /\  /\  /\

                return branch_part

            @property
            def _release(self):
                def get_dependency_on_resource(resource):
                    return jg_job_data.ParentDataDict("component_resources", resource.lower(), resource)

                def get_dependency_on_bundle(build_job_name, resources):
                    return jg_job_triggers.JobTriggerBuild(
                        job_name_parameter=build_job_name,
                        parent_job_data=[get_dependency_on_resource(resource) for resource, _ in resources.items()]
                    )

                def get_release_element(release_item, release_to, build_job_name, resources):
                    return jg_release.JobGraphElementReleaseBranched(
                        release_item=release_item,
                        release_to=release_to,
                        job_arrows=[get_dependency_on_bundle(build_job_name, resources)]
                    )

                def get_release_action(release_item, release_to):
                    return jg_release.JobGraphElementActionReleaseBranched(
                        release_item=release_item,
                        release_to=release_to,
                        job_params={"frequency": (jg_utils.TestFrequency.LAZY, None)},
                    )

                def get_release_element_and_action(release_item, release_to, build_job_name, resources):
                    return [
                        get_release_element(release_item, release_to, build_job_name, resources),
                        get_release_action(release_item, release_to)
                    ]

                def get_release_element_and_action_run(release_item, release_to, build_job_name):
                    return [
                        jg_release.JobGraphElementReleaseBranched(
                            release_item=release_item,
                            release_to=release_to,
                            job_arrows=[jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=build_job_name,
                                parent_job_data=[get_dependency_on_resource(release_item)]
                            )]
                        ),
                        get_release_action(release_item, release_to)
                    ]

                # worker_bundle_resources = WORKER_RESOURCES.copy()
                # worker_bundle_resources.update(RESHARDER_RESOURCES)
                # worker_bundle_resources.update(TASK_WORKER_RESOURCES)
                # worker_bundle_resources.update(SELECTION_RANK_WORKER_RESOURCES)
                # worker_bundle_resources.update(OFFER_WORKER_RESOURCES)
                # worker_bundle_resources.update(PREVIEW_WORKER_RESOURCES)

                release_part = super(self.__class__, self)._release
                # for release_to in [rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.stable]:
                #     release_part += get_release_element_and_action("CM", release_to, "CM_BUNDLE", CM_RESOURCES)
                #     release_part += get_release_element_and_action("WORKER", release_to, "WORKER_BUNDLE", worker_bundle_resources)

                # ------------- NEW \/  \/  \/  \/  \/  \/  \/  \/  \/  \/
                release_part += get_release_element_and_action("JUNK_OPTOZORAX_VIEWER", rm_const.ReleaseStatus.stable, "JUNK_OPTOZORAX_VIEWER_BUNDLE", VIEWER_RESOURCES)
                release_part += get_release_element_and_action_run(
                    "BANNERLAND_GENERATION_MODELS",
                    rm_const.ReleaseStatus.testing,
                    "RUN_JUNK_OPTOZORAX_SANDBOX_TASK",
                )
                # ------------- NEW /\  /\  /\  /\  /\  /\  /\  /\  /\  /\

                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = {rm_const.ReleaseStatus.stable: False, rm_const.ReleaseStatus.prestable: False}
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            def get_deploy_info(services, stage):
                return ri.NannyDeployInfo(services=[ri.DeployService(service) for service in services], stage=stage)

            def get_deploy_infos(prestable_services, stable_services):
                return [
                    get_deploy_info(prestable_services, rm_const.ReleaseStatus.prestable),
                    get_deploy_info(stable_services, rm_const.ReleaseStatus.stable),
                ]

            def get_releasable_item(resource, prestable_services, stable_services):
                return ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource),
                    deploy_infos=get_deploy_infos(prestable_services, stable_services)
                )

            result = super(self.__class__, self).releasable_items
            # for resource, _ in CM_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_cm_prestable", "blrt_cm_multidc_prestable"],
            #             ["blrt_cm_production", "blrt_cm_multidc"]
            #         )
            #     )
            # for resource, _ in WORKER_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_staging_worker_sas", "blrt_prestable_dyn_worker_sas", "blrt_prestable_perf_worker"],
            #             ["blrt_production_worker_sas", "blrt_production_dyn_worker_sas", "blrt_production_perf_worker"]
            #         )
            #     )

            # for resource, _ in RESHARDER_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_prestable_perf_resharder"],
            #             ["blrt_production_perf_resharder"]
            #         )
            #     )
            # for resource, _ in TASK_WORKER_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_prestable_perf_task_worker_sas", "blrt_prestable_dyn_task_worker_sas"],
            #             ["blrt_production_perf_task_worker_sas", "blrt_production_dyn_task_worker_sas"]
            #         )
            #     )
            # for resource, _ in SELECTION_RANK_WORKER_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_prestable_perf_selection_rank_worker"],
            #             ["blrt_production_perf_selection_rank_worker"]
            #         )
            #     )
            # for resource, _ in OFFER_WORKER_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_prestable_perf_offer_worker"],
            #             []
            #         )
            #     )
            # for resource, _ in PREVIEW_WORKER_RESOURCES.items():
            #     result.append(
            #         get_releasable_item(
            #             resource,
            #             ["blrt_prestable_preview_worker"],
            #             ["blrt_production_preview_worker"]
            #         )
            #     )

            for resource, _ in VIEWER_RESOURCES.items():
                result.append(
                    get_releasable_item(
                        resource,
                        [],
                        ["junk_optozorax_blrt_viewers"]
                    )
                )

            # ------------- NEW \/  \/  \/  \/  \/  \/  \/  \/  \/  \/
            # result.append(
            #     ri.ReleasableItem(
            #         name="BUILD_BANNER_LAND_BINARY_RESOURCES".lower(),
            #         data=ri.SandboxResourceData("BUILD_BANNER_LAND_BINARY_RESOURCES"),
            #     )
            # )
            result.append(
                ri.ReleasableItem(
                    name="BANNERLAND_GENERATION_MODELS".lower(),
                    data=ri.SandboxResourceData("BANNERLAND_GENERATION_MODELS"),
                )
            )
            result.append(
                ri.ReleasableItem(
                    name="SANDBOX_TASKS_BINARY".lower(),
                    data=ri.SandboxResourceData("SANDBOX_TASKS_BINARY"),
                )
            )
            # ------------- NEW /\  /\  /\  /\  /\  /\  /\  /\  /\  /\

            return result

    class Notify(configs.ReferenceBranchedConfig.Notify):
        mailing_list = [  # TODO: make a maillist?
            # "niknik@yandex-team.ru",
            # "bvshuryg@yandex-team.ru"
            "optozorax@yandex-team.ru"
        ]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = "TEST"
            assignee = "optozorax"
            ticket_type = "Release"
            summary_template = u"[BLRT] Blrt release {}"
            workflow = rm_const.Workflow.BETA_TEST
            add_commiters_as_followers = False
            followers = []

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
