# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class JupiterViewersCfg(configs.ReferenceTrunkConfig):
    component_group = 'component_info_general'
    name = "jupiter_viewers"
    responsible = "niknik"

    class Testenv(configs.ReferenceTrunkConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "jupiter-trunk"
        trunk_task_owner = "JUPITER_TESTS"

        class JobGraph(configs.ReferenceTrunkConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                trunk_part = super(self.__class__, self)._trunk_part
                trunk_part.append(
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="YA_MAKE_RELEASE_TO_NANNY",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 50 << 30,  # 50 Gb
                                },
                            },
                        },
                        ctx={
                            "targets": "robot/jupiter/packages/viewers",
                            "arts": "robot/jupiter/packages/viewers",
                            "arts_source": "",
                            "result_rt": "JUPITER_VIEWERS",
                            "result_rd": "Jupiter viewers",
                            "result_single_file": True,
                            sandbox_constants.DEFINITION_FLAGS_KEY: "-DDEBUGINFO_LINES_ONLY=yes",
                            sandbox_constants.USE_AAPI_FUSE: True,
                            sandbox_constants.ALLOW_AAPI_FALLBACK: True,
                            sandbox_constants.CHECKOUT_MODE: sandbox_constants.CHECKOUT_MODE_AUTO,
                            sandbox_constants.CHECKOUT: True,
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.CLEAR_BUILD_KEY: False,
                            sandbox_constants.CHECK_RETURN_CODE: True,
                            sandbox_constants.TESTS_REQUESTED: False,
                            sandbox_constants.YA_YT_DIR: "//home/jupiter/yamake_cache",
                            sandbox_constants.YA_YT_PROXY: "arnold.yt.yandex.net",
                            sandbox_constants.YA_YT_PUT: True,
                            sandbox_constants.YA_YT_STORE: True,
                            sandbox_constants.YA_YT_TOKEN_VAULT_NAME: "jupiter_yt_token",
                            sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: "JUPITER",
                        },
                        out={"JUPITER_VIEWERS": 30},
                    )
                )
                return trunk_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBase(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "jupiter_viewers_resource_id",
                                        "JUPITER_VIEWERS",
                                    )
                                )
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionSingleRelease(
                        job_name_parameter=rm_const.ReleaseStatus.stable,
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                        },
                    )
                )
                return release_part

    class Releases(configs.ReferenceTrunkConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="jupiter_viewers_resource_id",
                resource_type="JUPITER_VIEWERS",
            ),
        ]
