# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class K50ShoppingCfg(configs.ReferenceCIConfig):
    name = "k50_shopping"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="k50_shopping"),
        login="glebov-da",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "k50/shopping"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "K50"

        ya_make_abs_paths_glob = [
            "k50/shopping/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):
            _preset = ci_presets.SingleBuildPackageCiPreset(
                resource_names="K50_SHOPPING_PACKAGE",
                package_names="k50/shopping/package.json",
                build_ctx={
                    "package_type": "docker",
                    "docker_user": rm_const.ROBOT_RELEASER_USER_NAME,
                    "docker_token_vault_name": "RM_DOCKER_TOKEN",
                    "docker_image_repository": "k50",
                    "docker_registry": "registry.yandex.net",
                    "docker_push_image": True,
                    "release_to_ya_deploy": True,
                },
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.prestable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing),
                ],
            )

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="k50_shopping_package",
                    data=ri.SandboxResourceData("K50_SHOPPING_PACKAGE", ttl=180),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("shopping-prod"), rm_const.ReleaseStatus.stable),
                        ri.YaDeployInfo(ri.DeployService("shopping-demo"), rm_const.ReleaseStatus.prestable),
                        ri.YaDeployInfo(ri.DeployService("shopping-dev"), rm_const.ReleaseStatus.testing),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "glebov-da",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["k50_shopping_dev"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "arcadia/k50/shopping",
        ]
