# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.configs.basesearch import notifications_template, workflow_template
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as common_const


class KeyInvServiceCfg(configs.ReferenceBranchedConfig):
    name = "keyinv_service"
    display_name = "Web KeyInv Service"
    responsible = "okats"
    component_group = "reference_component_metricsed"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"
        testenv_db_owners = ["andreikkaa"]
        trunk_db = "ws-keyinv-trunk"
        branch_db_template = "ws-keyinv-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_KEY_INV_SERVICE",
                        ctx={
                            "notify_if_failed": "SEARCH-RELEASERS",
                            common_const.MUSL: True,
                            common_const.THINLTO: True,
                            common_const.DEFINITION_FLAGS_KEY: "-DCFLAGS=\"-mllvm -inline-threshold=1000 -fno-omit-frame-pointer\"",
                        },
                        out={"KEY_INV_SERVICE_EXECUTABLE": 90},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="keyinv_service",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "keyinv_executable_res_id",
                                        "KEY_INV_SERVICE_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "priemka",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="KEYINV_SERVICE",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "custom_template_name": "common.json",
                            "sample_beta": "hamster",
                            "scraper_over_yt_pool": "base_web_priemka",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="WEB"
                            ),
                        ),
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="key_inv_service",
                                        resource_name="KEY_INV_SERVICE_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )

                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="key_inv_service",
                    data=ri.SandboxResourceData("KEY_INV_SERVICE_EXECUTABLE", ttl=100),
                    deploy_infos=[ri.single_nanny_service("{}-web-keyinv-resources".format(location)) for location in rm_const.MAIN_LOCATIONS],
                ),
            ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        notifications = notifications_template

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["base_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/CaUODkKTwtMdwenQIkLLKQ"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "andreikkaa"
            queue = "BASEREL"
            dev_queue = "SEARCH"
            summary_template = "KeyInv service acceptance {}"
            use_task_author_as_assignee = True
            workflow = workflow_template
            add_commiters_as_followers = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/keyinvservice/releases/"
        ya_make_targets = [
            "search/base_search/daemons/keyinv",
        ]
        review_groups = [
            "base",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "keyinv_service": yappy_cfg.YappyBetaCfg(
                beta_name="multifullbeta1-web-priemka",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="multifullbeta1-web-priemka",
                        resources=[
                            yappy_cfg.YappyStaticResource(local_path="mmeta.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="intsearch.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="intsearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="embedding.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="embedding.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="invindex.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="keyinv.executable", param_name="keyinv_executable_res_id"
                            ),
                        ]
                    )
                ]
            )
        }
