# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils


class KwYTCfg(configs.ReferenceCIConfig):
    name = "kwyt"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="kwyt"),
        login="zagevalo",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "robot/kwyt"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "KWYT"

        ya_make_abs_paths_glob = [
            "robot/kwyt/**",
            "yql/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):

            _preset = ci_presets.SingleBuildPackageCiPreset(
                "KWYT_CM_PACKAGE",
                build_task_name="BUILD_KWYT_PACKAGE",
                package_names="robot/kwyt/packages/kwyt_cm.json",
                deploy_system=rm_const.DeploySystem.nanny.name,
                build_frequency=jg_utils.Lazy(),
                use_compression=False,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.prestable),
                ],
            )

    class ReleaseViewer(configs.ReferenceCIConfig.ReleaseViewer):
        kpi_alert = 7

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="kwyt_cm_package",
                    data=ri.SandboxResourceData("KWYT_CM_PACKAGE", ttl=90),
                    deploy_infos=[ri.NannyDeployInfo(ri.DeployService("kwyt_cm_prod"))],
                )
            ]

        release_followers_permanent = [
            "zagevalo",
            "lazv85",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):

        class Mail(configs.ReferenceCIConfig.Notify.Mail):
            mailing_list = ["kwyt"]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["kwyt_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "zagevalo"
            queue = "KWYTRELEASE"
            dev_queue = "KWYT"
            summary_template = u"KwYT {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "zagevalo",
                "lazv85",
            ]
            add_commiters_as_followers = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "robot/kwyt/changelogs/"
        observed_paths = [
            "arcadia/robot/kwyt",
            "arcadia/yql",
        ]
        review_groups = [
            "kwyt",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_prefix = "pre-stable"
        start_version = 52  # moved to The CI since the 51st branch
