# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_MAIL",
    "APP_HOST_STABLE_BRANCH_MAIL",
]


class MailGraphsCfg(configs.ReferenceBranchedConfig):
    name = "mail_graphs"
    responsible = configs.Responsible(abc=configs.Abc(role_id=16, component_id=2665), login="vyserenity")

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MAIL"
        each_rev_default = False

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={"vertical": "MAIL"},
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing),
                ],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[ri.single_nanny_service("production_app_host_vla_mail")],
                )
                for resource in RESOURCES
            ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/mail"
        tag_name = "apphost/conf/mail"

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "vyserenity"
            queue = "MAILDLV"
            summary_template = u"Приемка графов MAIL{}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = True
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "/pochta/backend/apphost-graph/mailreleases/"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/MAIL",
            "arcadia/apphost/conf/backends",
        ]
